/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.externaltask.ExternalTaskQueryBuilder;
import org.camunda.bpm.engine.impl.ProcessEngineImpl;
import org.camunda.bpm.engine.impl.identity.Authentication;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.rest.dto.externaltask.FetchExternalTasksExtendedDto;
import org.camunda.bpm.engine.rest.dto.externaltask.LockedExternalTaskDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.impl.FetchAndLockRequest;
import org.camunda.bpm.engine.rest.impl.FetchAndLockResult;
import org.camunda.bpm.engine.rest.spi.FetchAndLockHandler;
import org.camunda.bpm.engine.rest.util.EngineUtil;

public class FetchAndLockHandlerImpl
implements Runnable,
FetchAndLockHandler {
    protected static final ReentrantLock LOCK_MONITOR = ProcessEngineImpl.LOCK_MONITOR;
    protected static final Condition IS_EXTERNAL_TASK_AVAILABLE = ProcessEngineImpl.IS_EXTERNAL_TASK_AVAILABLE;
    protected static final long MAX_BACK_OFF_TIME = Long.MAX_VALUE;
    protected static final long MAX_TIMEOUT = 1800000L;
    protected BlockingQueue<FetchAndLockRequest> queue = new ArrayBlockingQueue<FetchAndLockRequest>(200);
    protected List<FetchAndLockRequest> pendingRequests = new ArrayList<FetchAndLockRequest>();
    protected Thread handlerThread = new Thread((Runnable)this, this.getClass().getSimpleName());
    protected volatile boolean isRunning = false;

    @Override
    public void run() {
        while (this.isRunning) {
            try {
                this.acquire();
            }
            catch (Throwable throwable) {}
        }
        this.rejectPendingRequests();
    }

    protected void acquire() {
        this.queue.drainTo(this.pendingRequests);
        long backoffTime = Long.MAX_VALUE;
        Iterator<FetchAndLockRequest> iterator = this.pendingRequests.iterator();
        while (iterator.hasNext()) {
            FetchAndLockRequest pendingRequest = iterator.next();
            FetchAndLockResult result = this.tryFetchAndLock(pendingRequest);
            if (result.wasSuccessful()) {
                List<LockedExternalTaskDto> lockedTasks = result.getTasks();
                if (!lockedTasks.isEmpty() || this.isExpired(pendingRequest)) {
                    AsyncResponse asyncResponse = pendingRequest.getAsyncResponse();
                    asyncResponse.resume(lockedTasks);
                    iterator.remove();
                    continue;
                }
                long timeout = pendingRequest.getTimeoutTimestamp();
                if (timeout >= backoffTime) continue;
                backoffTime = timeout;
                continue;
            }
            AsyncResponse asyncResponse = pendingRequest.getAsyncResponse();
            Throwable processEngineException = result.getThrowable();
            asyncResponse.resume(processEngineException);
            iterator.remove();
        }
        this.suspend(Math.max(0L, backoffTime - ClockUtil.getCurrentTime().getTime()));
    }

    @Override
    public void start() {
        if (this.isRunning) {
            return;
        }
        this.isRunning = true;
        this.handlerThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        LOCK_MONITOR.lock();
        try {
            this.isRunning = false;
            this.notifyAcquisition();
        }
        finally {
            LOCK_MONITOR.unlock();
        }
    }

    protected void suspend(long millis) {
        if (millis <= 0L) {
            return;
        }
        this.suspendAcquisition(millis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void suspendAcquisition(long millis) {
        if (this.queue.isEmpty() && this.isRunning) {
            LOCK_MONITOR.lock();
            try {
                if (this.queue.isEmpty() && this.isRunning) {
                    IS_EXTERNAL_TASK_AVAILABLE.await(millis, TimeUnit.MILLISECONDS);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            finally {
                LOCK_MONITOR.unlock();
            }
        }
    }

    protected void addRequest(FetchAndLockRequest request) {
        if (!this.queue.offer(request)) {
            AsyncResponse asyncResponse = request.getAsyncResponse();
            this.errorTooManyRequests(asyncResponse);
        }
        this.notifyAcquisition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyAcquisition() {
        LOCK_MONITOR.lock();
        try {
            IS_EXTERNAL_TASK_AVAILABLE.signal();
        }
        finally {
            LOCK_MONITOR.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FetchAndLockResult tryFetchAndLock(FetchAndLockRequest request) {
        ProcessEngine processEngine = null;
        IdentityService identityService = null;
        FetchAndLockResult result = null;
        try {
            processEngine = this.getProcessEngine(request);
            identityService = processEngine.getIdentityService();
            identityService.setAuthentication(request.getAuthentication());
            FetchExternalTasksExtendedDto fetchingDto = request.getDto();
            List<LockedExternalTaskDto> lockedTasks = this.executeFetchAndLock(fetchingDto, processEngine);
            result = FetchAndLockResult.successful(lockedTasks);
        }
        catch (Throwable e) {
            result = FetchAndLockResult.failed(e);
        }
        finally {
            if (identityService != null) {
                identityService.clearAuthentication();
            }
        }
        return result;
    }

    protected List<LockedExternalTaskDto> executeFetchAndLock(FetchExternalTasksExtendedDto fetchingDto, ProcessEngine processEngine) {
        ExternalTaskQueryBuilder fetchBuilder = fetchingDto.buildQuery(processEngine);
        List externalTasks = fetchBuilder.execute();
        return LockedExternalTaskDto.fromLockedExternalTasks(externalTasks);
    }

    protected void invalidRequest(AsyncResponse asyncResponse, String message) {
        InvalidRequestException invalidRequestException = new InvalidRequestException(Response.Status.BAD_REQUEST, message);
        asyncResponse.resume((Throwable)invalidRequestException);
    }

    protected void errorTooManyRequests(AsyncResponse asyncResponse) {
        String errorMessage = "At the moment the server has to handle too many requests at the same time. Please try again later.";
        InvalidRequestException invalidRequestException = new InvalidRequestException(Response.Status.INTERNAL_SERVER_ERROR, errorMessage);
        asyncResponse.resume((Throwable)invalidRequestException);
    }

    protected void rejectPendingRequests() {
        for (FetchAndLockRequest pendingRequest : this.pendingRequests) {
            AsyncResponse asyncResponse = pendingRequest.getAsyncResponse();
            this.invalidRequest(asyncResponse, "Request rejected due to shutdown of application server.");
        }
    }

    protected ProcessEngine getProcessEngine(FetchAndLockRequest request) {
        String processEngineName = request.getProcessEngineName();
        return EngineUtil.lookupProcessEngine(processEngineName);
    }

    protected boolean isExpired(FetchAndLockRequest request) {
        long currentTime = ClockUtil.getCurrentTime().getTime();
        long timeout = request.getTimeoutTimestamp();
        return timeout <= currentTime;
    }

    @Override
    public void addPendingRequest(FetchExternalTasksExtendedDto dto, AsyncResponse asyncResponse, ProcessEngine processEngine) {
        Long asyncResponseTimeout = dto.getAsyncResponseTimeout();
        if (asyncResponseTimeout != null && asyncResponseTimeout > 1800000L) {
            this.invalidRequest(asyncResponse, "The asynchronous response timeout cannot be set to a value greater than 1800000 milliseconds");
            return;
        }
        IdentityService identityService = processEngine.getIdentityService();
        Authentication authentication = identityService.getCurrentAuthentication();
        String processEngineName = processEngine.getName();
        FetchAndLockRequest incomingRequest = new FetchAndLockRequest().setProcessEngineName(processEngineName).setAsyncResponse(asyncResponse).setAuthentication(authentication).setDto(dto);
        FetchAndLockResult result = this.tryFetchAndLock(incomingRequest);
        if (result.wasSuccessful()) {
            List<LockedExternalTaskDto> lockedTasks = result.getTasks();
            if (!lockedTasks.isEmpty() || dto.getAsyncResponseTimeout() == null) {
                asyncResponse.resume(lockedTasks);
            } else {
                this.addRequest(incomingRequest);
            }
        } else {
            Throwable processEngineException = result.getThrowable();
            asyncResponse.resume(processEngineException);
        }
    }

    public List<FetchAndLockRequest> getPendingRequests() {
        return this.pendingRequests;
    }
}

