/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.spring.test.components.scope;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.logging.Handler;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;
import org.camunda.bpm.engine.spring.components.scope.ProcessScope;
import org.junit.Assert;
import org.junit.Test;

public class ProcessScopeTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldLogExceptionStacktrace() throws IOException {
        Logger logger = Logger.getLogger(ProcessScope.class.getName());
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            StreamHandler handler = new StreamHandler(out, new SimpleFormatter());
            logger.addHandler(handler);
            try {
                ProcessScope scope = new ProcessScope();
                Object variable = scope.get("testObject", null);
                Assert.assertNull((Object)variable);
            }
            finally {
                ((Handler)handler).flush();
                ((Handler)handler).close();
                logger.removeHandler(handler);
            }
            String message = new String(out.toByteArray(), StandardCharsets.UTF_8);
            Assert.assertTrue((!message.isEmpty() ? 1 : 0) != 0);
            Assert.assertTrue((boolean)message.contains("org.camunda.bpm.engine.spring.components.scope.ProcessScope get"));
            Assert.assertTrue((boolean)message.contains("couldn't return value from process scope! java.lang.NullPointerException"));
            Assert.assertTrue((boolean)message.contains("at org.camunda.bpm.engine.spring.components.scope.ProcessScope.getExecutionId(ProcessScope.java:"));
            Assert.assertTrue((boolean)message.contains("at org.camunda.bpm.engine.spring.components.scope.ProcessScope.getConversationId(ProcessScope.java:"));
            Assert.assertTrue((boolean)message.contains("at org.camunda.bpm.engine.spring.components.scope.ProcessScope.get(ProcessScope.java:"));
            Assert.assertTrue((boolean)message.contains("at org.camunda.bpm.engine.spring.test.components.scope.ProcessScopeTest.shouldLogExceptionStacktrace(ProcessScopeTest.java:"));
        }
    }
}

