/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.spring.test.scripttask;

import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.ScriptEvaluationException;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.ScriptTaskBuilder;
import org.junit.After;
import org.junit.Assert;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractScriptTaskTest {
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private RepositoryService repositoryService;
    private static final String TEST_BEAN_NAME = "name property of testbean";
    private List<String> deploymentIds = new ArrayList<String>();

    @After
    public void after() {
        for (String deploymentId : this.deploymentIds) {
            this.repositoryService.deleteDeployment(deploymentId, true);
        }
    }

    protected void deployProcess(BpmnModelInstance process) {
        Deployment deployment = this.repositoryService.createDeployment().addModelInstance("testProcess.bpmn", process).deploy();
        this.deploymentIds.add(deployment.getId());
    }

    protected void deployProcess(String scriptFormat, String scriptText) {
        BpmnModelInstance process = this.createProcess(scriptFormat, scriptText);
        this.deployProcess(process);
    }

    protected BpmnModelInstance createProcess(String scriptFormat, String scriptText) {
        return ((ScriptTaskBuilder)((ScriptTaskBuilder)Bpmn.createExecutableProcess((String)"testProcess").startEvent().scriptTask().scriptFormat(scriptFormat)).scriptText(scriptText)).userTask().endEvent().done();
    }

    protected void testSpringBeanVisibility(String scriptFormat, String scriptText) {
        this.testSpringBeanVisibility(scriptFormat, scriptText, true);
    }

    protected void testSpringBeanVisibility(String scriptFormat, String scriptText, boolean visible) {
        this.deployProcess(scriptFormat, scriptText);
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess");
        Object variableValue = this.runtimeService.getVariable(pi.getId(), "foo");
        if (visible) {
            Assert.assertEquals((Object)TEST_BEAN_NAME, (Object)variableValue);
        } else {
            Assert.assertNull((Object)variableValue);
        }
    }

    protected void testNoSpringBean(String scriptFormat, String scriptText) {
        this.deployProcess(scriptFormat, scriptText);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runtimeService.startProcessInstanceByKey("testProcess")).isInstanceOf(ScriptEvaluationException.class)).hasMessageContaining("testbean");
    }
}

