/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.spring.test.transaction;

import javax.sql.DataSource;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.junit.Assert;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.annotation.Transactional;

public class UserBean {
    private RuntimeService runtimeService;
    private TaskService taskService;
    private DataSource dataSource;

    @Transactional
    public void hello() {
        this.runtimeService.startProcessInstanceByKey("helloProcess");
    }

    @Transactional
    public void completeTask(String taskId) {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        int results = (Integer)jdbcTemplate.queryForObject("select count(*) from MY_TABLE", Integer.class);
        Assert.assertEquals((long)1L, (long)results);
        int nrOfRows = jdbcTemplate.update("insert into MY_TABLE values ('test');");
        if (nrOfRows != 1) {
            throw new RuntimeException("Insert into MY_TABLE failed");
        }
        results = (Integer)jdbcTemplate.queryForObject("select count(*) from MY_TABLE", Integer.class);
        Assert.assertEquals((long)2L, (long)results);
        this.taskService.complete(taskId);
    }

    @Required
    public void setRuntimeService(RuntimeService runtimeService) {
        this.runtimeService = runtimeService;
    }

    @Required
    public void setTaskService(TaskService taskService) {
        this.taskService = taskService;
    }

    @Required
    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }
}

