/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.spring.test.transaction.crdb;

import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.spring.test.transaction.crdb.CrdbConcurrencyConflictDelegate;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:org/camunda/bpm/engine/spring/test/transaction/CrdbTransactionIntegrationTest-applicationContext.xml"})
public class CrdbTransactionIntegrationTest {
    @Rule
    @Autowired
    public ProcessEngineRule rule;
    @Autowired
    public ProcessEngineConfigurationImpl processEngineConfiguration;
    @Autowired
    HistoryService historyService;

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/spring/test/transaction/CrdbTransactionIntegrationTest.simpleProcess.bpmn20.xml"})
    public void shouldRetryEngineManagedTransaction() {
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                commandContext.getProcessEngineConfiguration().getRuntimeService().startProcessInstanceByKey("simpleProcess");
                return null;
            }

            public boolean isRetryable() {
                return true;
            }
        });
        long historicProcessInstanceCount = this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey("simpleProcess").count();
        Assertions.assertThat((long)historicProcessInstanceCount).isEqualTo(1L);
        Assertions.assertThat((int)CrdbConcurrencyConflictDelegate.getTransactions().size()).isEqualTo(2);
    }
}

