/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.spring.test.transaction.inner.rollback;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:org/camunda/bpm/engine/spring/test/transaction/SpringInnerTransactionRollbackTest-applicationContext.xml"})
public class SpringInnerTransactionRollbackTest {
    @Rule
    @Autowired
    public ProcessEngineRule rule;
    @Autowired
    public ProcessEngine processEngine;
    @Autowired
    RuntimeService runtimeService;
    @Autowired
    HistoryService historyService;

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/spring/test/transaction/SpringInnerTransactionRollbackTest.shouldRollbackProcessData-outer.bpmn20.xml", "org/camunda/bpm/engine/spring/test/transaction/SpringInnerTransactionRollbackTest.shouldRollbackProcessData-inner.bpmn20.xml"})
    public void shouldRollbackProcessData() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("OuterTxNestedTransactionTest");
        ProcessInstance outerProcessInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance.getId()).singleResult();
        Assertions.assertThat((Object)outerProcessInstance).isNull();
        List innerProcessInstances = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("InnerTxNestedTransactionTest").list();
        Assertions.assertThat((List)innerProcessInstances).isEmpty();
        List innerProcessinstances = this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey("InnerTxNestedTransactionTest").list();
        Assertions.assertThat((List)innerProcessinstances).isEmpty();
    }
}

