/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.spring.test.transaction.modification;

import org.apache.ibatis.logging.LogFactory;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.history.HistoricVariableInstance;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.repository.DeploymentBuilder;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.spring.test.transaction.modification.UserBean;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.IntermediateCatchEventBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:org/camunda/bpm/engine/spring/test/transaction/ProcessInstanceModificationInTransactionTest-applicationContext.xml"})
public class ProcessInstanceModificationInTransactionTest {
    @Autowired
    @Rule
    public ProcessEngineRule rule;
    @Autowired
    public ProcessEngine processEngine;
    @Autowired
    RuntimeService runtimeService;
    @Autowired
    RepositoryService repositoryService;
    @Autowired
    UserBean userBean;

    @Before
    public void init() {
        LogFactory.useSlf4jLogging();
    }

    @Test
    public void shouldBeAbleToPerformModification() {
        BpmnModelInstance modelInstance = ((IntermediateCatchEventBuilder)((IntermediateCatchEventBuilder)Bpmn.createExecutableProcess((String)"TestProcess").startEvent().intermediateCatchEvent("TimerEvent").timerWithDate("${calculateTimerDate.execute(execution)}")).camundaExecutionListenerDelegateExpression("end", "${deleteVariableListener}")).endEvent().done();
        this.deployModelInstance(modelInstance);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("TestProcess");
        this.userBean.completeUserTaskAndModifyInstanceInOneTransaction(procInst);
        VariableInstance variable = (VariableInstance)this.rule.getRuntimeService().createVariableInstanceQuery().processInstanceIdIn(new String[]{procInst.getId()}).variableName("createDate").singleResult();
        Assert.assertNotNull((Object)variable);
        HistoricVariableInstance historicVariable = (HistoricVariableInstance)this.rule.getHistoryService().createHistoricVariableInstanceQuery().singleResult();
        Assert.assertEquals((Object)variable.getName(), (Object)historicVariable.getName());
        Assert.assertEquals((Object)"CREATED", (Object)historicVariable.getState());
    }

    private void deployModelInstance(BpmnModelInstance modelInstance) {
        DeploymentBuilder deploymentbuilder = this.repositoryService.createDeployment();
        deploymentbuilder.addModelInstance("process0.bpmn", modelInstance);
        Deployment deployment = deploymentbuilder.deploy();
        this.rule.manageDeployment(deployment);
    }
}

