/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.util.ArrayList;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.impl.cmd.ExternalTaskCmd;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.persistence.entity.ExternalTaskEntity;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyChange;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class SetExternalTaskRetriesCmd
extends ExternalTaskCmd {
    protected int retries;
    protected boolean writeUserOperationLog;

    public SetExternalTaskRetriesCmd(String externalTaskId, int retries, boolean writeUserOperationLog) {
        super(externalTaskId);
        this.retries = retries;
        this.writeUserOperationLog = writeUserOperationLog;
    }

    @Override
    protected void validateInput() {
        EnsureUtil.ensureGreaterThanOrEqual(BadUserRequestException.class, "The number of retries cannot be negative", "retries", this.retries, 0L);
    }

    @Override
    protected void execute(ExternalTaskEntity externalTask) {
        if (this.writeUserOperationLog) {
            ArrayList<PropertyChange> propertyChanges = new ArrayList<PropertyChange>();
            propertyChanges.add(new PropertyChange("retries", externalTask.getRetries(), this.retries));
            Context.getCommandContext().getOperationLogManager().logProcessInstanceOperation("SetExternalTaskRetries", externalTask.getProcessInstanceId(), externalTask.getProcessDefinitionId(), externalTask.getProcessDefinitionKey(), propertyChanges);
        }
        externalTask.setRetriesAndManageIncidents(this.retries);
    }
}

