/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd.optimize;

import java.util.Date;
import java.util.List;
import org.camunda.bpm.engine.history.HistoricVariableUpdate;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.cmd.CommandLogger;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricDetailVariableInstanceUpdateEntity;
import org.camunda.bpm.engine.impl.variable.serializer.AbstractTypedValueSerializer;

public class OptimizeHistoricVariableUpdateQueryCmd
implements Command<List<HistoricVariableUpdate>> {
    private static final CommandLogger LOG = ProcessEngineLogger.CMD_LOGGER;
    protected Date occurredAfter;
    protected Date occurredAt;
    protected int maxResults;

    public OptimizeHistoricVariableUpdateQueryCmd(Date occurredAfter, Date occurredAt, int maxResults) {
        this.occurredAfter = occurredAfter;
        this.occurredAt = occurredAt;
        this.maxResults = maxResults;
    }

    @Override
    public List<HistoricVariableUpdate> execute(CommandContext commandContext) {
        List<HistoricVariableUpdate> historicVariableUpdates = commandContext.getOptimizeManager().getHistoricVariableUpdates(this.occurredAfter, this.occurredAt, this.maxResults);
        this.fetchVariableValues(historicVariableUpdates);
        return historicVariableUpdates;
    }

    private void fetchVariableValues(List<HistoricVariableUpdate> historicVariableUpdates) {
        if (historicVariableUpdates != null) {
            for (HistoricVariableUpdate historicDetail : historicVariableUpdates) {
                HistoricDetailVariableInstanceUpdateEntity entity;
                if (!(historicDetail instanceof HistoricDetailVariableInstanceUpdateEntity) || !this.isNotByteArrayVariableType(entity = (HistoricDetailVariableInstanceUpdateEntity)historicDetail)) continue;
                try {
                    entity.getTypedValue(false);
                }
                catch (Exception t) {
                    LOG.exceptionWhileGettingValueForVariable(t);
                }
            }
        }
    }

    protected boolean isNotByteArrayVariableType(HistoricDetailVariableInstanceUpdateEntity entity) {
        return !AbstractTypedValueSerializer.BINARY_VALUE_TYPES.contains(entity.getSerializer().getType().getName());
    }
}

