/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.interceptor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.camunda.bpm.application.InvocationContext;
import org.camunda.bpm.application.ProcessApplicationReference;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.OptimisticLockingException;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.TaskAlreadyClaimedException;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cfg.TransactionContext;
import org.camunda.bpm.engine.impl.cfg.TransactionContextFactory;
import org.camunda.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionManager;
import org.camunda.bpm.engine.impl.cmmn.entity.runtime.CaseExecutionEntity;
import org.camunda.bpm.engine.impl.cmmn.entity.runtime.CaseExecutionManager;
import org.camunda.bpm.engine.impl.cmmn.entity.runtime.CaseSentryPartManager;
import org.camunda.bpm.engine.impl.cmmn.operation.CmmnAtomicOperation;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.context.ProcessApplicationContextUtil;
import org.camunda.bpm.engine.impl.db.entitymanager.DbEntityManager;
import org.camunda.bpm.engine.impl.db.sql.DbSqlSession;
import org.camunda.bpm.engine.impl.dmn.entity.repository.DecisionDefinitionManager;
import org.camunda.bpm.engine.impl.dmn.entity.repository.DecisionRequirementsDefinitionManager;
import org.camunda.bpm.engine.impl.history.event.HistoricDecisionInstanceManager;
import org.camunda.bpm.engine.impl.identity.Authentication;
import org.camunda.bpm.engine.impl.identity.ReadOnlyIdentityProvider;
import org.camunda.bpm.engine.impl.identity.WritableIdentityProvider;
import org.camunda.bpm.engine.impl.interceptor.CommandContextListener;
import org.camunda.bpm.engine.impl.interceptor.CommandInvocationContext;
import org.camunda.bpm.engine.impl.interceptor.ContextLogger;
import org.camunda.bpm.engine.impl.interceptor.Session;
import org.camunda.bpm.engine.impl.interceptor.SessionFactory;
import org.camunda.bpm.engine.impl.jobexecutor.FailedJobCommandFactory;
import org.camunda.bpm.engine.impl.optimize.OptimizeManager;
import org.camunda.bpm.engine.impl.persistence.entity.AttachmentManager;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationManager;
import org.camunda.bpm.engine.impl.persistence.entity.BatchManager;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayManager;
import org.camunda.bpm.engine.impl.persistence.entity.CommentManager;
import org.camunda.bpm.engine.impl.persistence.entity.DeploymentManager;
import org.camunda.bpm.engine.impl.persistence.entity.EventSubscriptionManager;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionManager;
import org.camunda.bpm.engine.impl.persistence.entity.ExternalTaskManager;
import org.camunda.bpm.engine.impl.persistence.entity.FilterManager;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricActivityInstanceManager;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricBatchManager;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricCaseActivityInstanceManager;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricCaseInstanceManager;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricDetailManager;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricExternalTaskLogManager;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricIdentityLinkLogManager;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricIncidentManager;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricJobLogManager;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricProcessInstanceManager;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricStatisticsManager;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricTaskInstanceManager;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricVariableInstanceManager;
import org.camunda.bpm.engine.impl.persistence.entity.IdentityInfoManager;
import org.camunda.bpm.engine.impl.persistence.entity.IdentityLinkManager;
import org.camunda.bpm.engine.impl.persistence.entity.IncidentManager;
import org.camunda.bpm.engine.impl.persistence.entity.JobDefinitionManager;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobManager;
import org.camunda.bpm.engine.impl.persistence.entity.MeterLogManager;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionManager;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyManager;
import org.camunda.bpm.engine.impl.persistence.entity.ReportManager;
import org.camunda.bpm.engine.impl.persistence.entity.ResourceManager;
import org.camunda.bpm.engine.impl.persistence.entity.StatisticsManager;
import org.camunda.bpm.engine.impl.persistence.entity.TableDataManager;
import org.camunda.bpm.engine.impl.persistence.entity.TaskManager;
import org.camunda.bpm.engine.impl.persistence.entity.TaskReportManager;
import org.camunda.bpm.engine.impl.persistence.entity.TenantManager;
import org.camunda.bpm.engine.impl.persistence.entity.UserOperationLogManager;
import org.camunda.bpm.engine.impl.persistence.entity.VariableInstanceManager;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class CommandContext {
    private static final ContextLogger LOG = ProcessEngineLogger.CONTEXT_LOGGER;
    protected boolean authorizationCheckEnabled = true;
    protected boolean userOperationLogEnabled = true;
    protected boolean tenantCheckEnabled = true;
    protected boolean restrictUserOperationLogToAuthenticatedUsers;
    protected TransactionContext transactionContext;
    protected Map<Class<?>, SessionFactory> sessionFactories;
    protected Map<Class<?>, Session> sessions = new HashMap();
    protected List<Session> sessionList = new ArrayList<Session>();
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected FailedJobCommandFactory failedJobCommandFactory;
    protected JobEntity currentJob = null;
    protected List<CommandContextListener> commandContextListeners = new LinkedList<CommandContextListener>();
    protected String operationId;

    public CommandContext(ProcessEngineConfigurationImpl processEngineConfiguration) {
        this(processEngineConfiguration, processEngineConfiguration.getTransactionContextFactory());
    }

    public CommandContext(ProcessEngineConfigurationImpl processEngineConfiguration, TransactionContextFactory transactionContextFactory) {
        this.processEngineConfiguration = processEngineConfiguration;
        this.failedJobCommandFactory = processEngineConfiguration.getFailedJobCommandFactory();
        this.sessionFactories = processEngineConfiguration.getSessionFactories();
        this.transactionContext = transactionContextFactory.openTransactionContext(this);
        this.restrictUserOperationLogToAuthenticatedUsers = processEngineConfiguration.isRestrictUserOperationLogToAuthenticatedUsers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performOperation(final CmmnAtomicOperation executionOperation, final CaseExecutionEntity execution) {
        ProcessApplicationReference targetProcessApplication = this.getTargetProcessApplication(execution);
        if (this.requiresContextSwitch(targetProcessApplication)) {
            Context.executeWithinProcessApplication(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    CommandContext.this.performOperation(executionOperation, execution);
                    return null;
                }
            }, targetProcessApplication, new InvocationContext(execution));
        } else {
            try {
                Context.setExecutionContext(execution);
                LOG.debugExecutingAtomicOperation(executionOperation, execution);
                executionOperation.execute(execution);
            }
            finally {
                Context.removeExecutionContext();
            }
        }
    }

    public ProcessEngineConfigurationImpl getProcessEngineConfiguration() {
        return this.processEngineConfiguration;
    }

    protected ProcessApplicationReference getTargetProcessApplication(CaseExecutionEntity execution) {
        return ProcessApplicationContextUtil.getTargetProcessApplication(execution);
    }

    protected boolean requiresContextSwitch(ProcessApplicationReference processApplicationReference) {
        return ProcessApplicationContextUtil.requiresContextSwitch(processApplicationReference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close(CommandInvocationContext commandInvocationContext) {
        block31: {
            try {
                try {
                    try {
                        if (commandInvocationContext.getThrowable() == null) {
                            this.fireCommandContextClose();
                            this.flushSessions();
                        }
                    }
                    catch (Throwable exception) {
                        try {
                            commandInvocationContext.trySetThrowable(exception);
                            break block31;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            try {
                                if (commandInvocationContext.getThrowable() == null) {
                                    this.transactionContext.commit();
                                }
                            }
                            catch (Throwable exception2) {
                                commandInvocationContext.trySetThrowable(exception2);
                            }
                            if (commandInvocationContext.getThrowable() != null) {
                                this.fireCommandFailed(commandInvocationContext.getThrowable());
                                if (this.shouldLogInfo(commandInvocationContext.getThrowable())) {
                                    LOG.infoException(commandInvocationContext.getThrowable());
                                } else if (this.shouldLogFine(commandInvocationContext.getThrowable())) {
                                    LOG.debugException(commandInvocationContext.getThrowable());
                                } else {
                                    LOG.errorException(commandInvocationContext.getThrowable());
                                }
                                this.transactionContext.rollback();
                            }
                        }
                    }
                    try {
                        if (commandInvocationContext.getThrowable() == null) {
                            this.transactionContext.commit();
                        }
                    }
                    catch (Throwable exception) {
                        commandInvocationContext.trySetThrowable(exception);
                    }
                    if (commandInvocationContext.getThrowable() != null) {
                        this.fireCommandFailed(commandInvocationContext.getThrowable());
                        if (this.shouldLogInfo(commandInvocationContext.getThrowable())) {
                            LOG.infoException(commandInvocationContext.getThrowable());
                        } else if (this.shouldLogFine(commandInvocationContext.getThrowable())) {
                            LOG.debugException(commandInvocationContext.getThrowable());
                        } else {
                            LOG.errorException(commandInvocationContext.getThrowable());
                        }
                        this.transactionContext.rollback();
                    }
                }
                catch (Throwable exception) {
                    commandInvocationContext.trySetThrowable(exception);
                }
                finally {
                    this.closeSessions(commandInvocationContext);
                }
            }
            catch (Throwable exception) {
                commandInvocationContext.trySetThrowable(exception);
            }
        }
        commandInvocationContext.rethrow();
    }

    protected boolean shouldLogInfo(Throwable exception) {
        return exception instanceof TaskAlreadyClaimedException;
    }

    protected boolean shouldLogFine(Throwable exception) {
        return exception instanceof OptimisticLockingException || exception instanceof BadUserRequestException;
    }

    protected void fireCommandContextClose() {
        for (CommandContextListener listener : this.commandContextListeners) {
            listener.onCommandContextClose(this);
        }
    }

    protected void fireCommandFailed(Throwable t) {
        for (CommandContextListener listener : this.commandContextListeners) {
            try {
                listener.onCommandFailed(this, t);
            }
            catch (Throwable ex) {
                LOG.exceptionWhileInvokingOnCommandFailed(t);
            }
        }
    }

    protected void flushSessions() {
        for (int i = 0; i < this.sessionList.size(); ++i) {
            this.sessionList.get(i).flush();
        }
    }

    protected void closeSessions(CommandInvocationContext commandInvocationContext) {
        for (Session session : this.sessionList) {
            try {
                session.close();
            }
            catch (Throwable exception) {
                commandInvocationContext.trySetThrowable(exception);
            }
        }
    }

    public <T> T getSession(Class<T> sessionClass) {
        Session session = this.sessions.get(sessionClass);
        if (session == null) {
            SessionFactory sessionFactory = this.sessionFactories.get(sessionClass);
            EnsureUtil.ensureNotNull("no session factory configured for " + sessionClass.getName(), "sessionFactory", (Object)sessionFactory);
            session = sessionFactory.openSession();
            this.sessions.put(sessionClass, session);
            this.sessionList.add(0, session);
        }
        return (T)session;
    }

    public DbEntityManager getDbEntityManager() {
        return this.getSession(DbEntityManager.class);
    }

    public DbSqlSession getDbSqlSession() {
        return this.getSession(DbSqlSession.class);
    }

    public DeploymentManager getDeploymentManager() {
        return this.getSession(DeploymentManager.class);
    }

    public ResourceManager getResourceManager() {
        return this.getSession(ResourceManager.class);
    }

    public ByteArrayManager getByteArrayManager() {
        return this.getSession(ByteArrayManager.class);
    }

    public ProcessDefinitionManager getProcessDefinitionManager() {
        return this.getSession(ProcessDefinitionManager.class);
    }

    public ExecutionManager getExecutionManager() {
        return this.getSession(ExecutionManager.class);
    }

    public TaskManager getTaskManager() {
        return this.getSession(TaskManager.class);
    }

    public TaskReportManager getTaskReportManager() {
        return this.getSession(TaskReportManager.class);
    }

    public MeterLogManager getMeterLogManager() {
        return this.getSession(MeterLogManager.class);
    }

    public IdentityLinkManager getIdentityLinkManager() {
        return this.getSession(IdentityLinkManager.class);
    }

    public VariableInstanceManager getVariableInstanceManager() {
        return this.getSession(VariableInstanceManager.class);
    }

    public HistoricProcessInstanceManager getHistoricProcessInstanceManager() {
        return this.getSession(HistoricProcessInstanceManager.class);
    }

    public HistoricCaseInstanceManager getHistoricCaseInstanceManager() {
        return this.getSession(HistoricCaseInstanceManager.class);
    }

    public HistoricDetailManager getHistoricDetailManager() {
        return this.getSession(HistoricDetailManager.class);
    }

    public UserOperationLogManager getOperationLogManager() {
        return this.getSession(UserOperationLogManager.class);
    }

    public HistoricVariableInstanceManager getHistoricVariableInstanceManager() {
        return this.getSession(HistoricVariableInstanceManager.class);
    }

    public HistoricActivityInstanceManager getHistoricActivityInstanceManager() {
        return this.getSession(HistoricActivityInstanceManager.class);
    }

    public HistoricCaseActivityInstanceManager getHistoricCaseActivityInstanceManager() {
        return this.getSession(HistoricCaseActivityInstanceManager.class);
    }

    public HistoricTaskInstanceManager getHistoricTaskInstanceManager() {
        return this.getSession(HistoricTaskInstanceManager.class);
    }

    public HistoricIncidentManager getHistoricIncidentManager() {
        return this.getSession(HistoricIncidentManager.class);
    }

    public HistoricIdentityLinkLogManager getHistoricIdentityLinkManager() {
        return this.getSession(HistoricIdentityLinkLogManager.class);
    }

    public JobManager getJobManager() {
        return this.getSession(JobManager.class);
    }

    public BatchManager getBatchManager() {
        return this.getSession(BatchManager.class);
    }

    public HistoricBatchManager getHistoricBatchManager() {
        return this.getSession(HistoricBatchManager.class);
    }

    public JobDefinitionManager getJobDefinitionManager() {
        return this.getSession(JobDefinitionManager.class);
    }

    public IncidentManager getIncidentManager() {
        return this.getSession(IncidentManager.class);
    }

    public IdentityInfoManager getIdentityInfoManager() {
        return this.getSession(IdentityInfoManager.class);
    }

    public AttachmentManager getAttachmentManager() {
        return this.getSession(AttachmentManager.class);
    }

    public TableDataManager getTableDataManager() {
        return this.getSession(TableDataManager.class);
    }

    public CommentManager getCommentManager() {
        return this.getSession(CommentManager.class);
    }

    public EventSubscriptionManager getEventSubscriptionManager() {
        return this.getSession(EventSubscriptionManager.class);
    }

    public Map<Class<?>, SessionFactory> getSessionFactories() {
        return this.sessionFactories;
    }

    public PropertyManager getPropertyManager() {
        return this.getSession(PropertyManager.class);
    }

    public StatisticsManager getStatisticsManager() {
        return this.getSession(StatisticsManager.class);
    }

    public HistoricStatisticsManager getHistoricStatisticsManager() {
        return this.getSession(HistoricStatisticsManager.class);
    }

    public HistoricJobLogManager getHistoricJobLogManager() {
        return this.getSession(HistoricJobLogManager.class);
    }

    public HistoricExternalTaskLogManager getHistoricExternalTaskLogManager() {
        return this.getSession(HistoricExternalTaskLogManager.class);
    }

    public ReportManager getHistoricReportManager() {
        return this.getSession(ReportManager.class);
    }

    public AuthorizationManager getAuthorizationManager() {
        return this.getSession(AuthorizationManager.class);
    }

    public ReadOnlyIdentityProvider getReadOnlyIdentityProvider() {
        return this.getSession(ReadOnlyIdentityProvider.class);
    }

    public WritableIdentityProvider getWritableIdentityProvider() {
        return this.getSession(WritableIdentityProvider.class);
    }

    public TenantManager getTenantManager() {
        return this.getSession(TenantManager.class);
    }

    public CaseDefinitionManager getCaseDefinitionManager() {
        return this.getSession(CaseDefinitionManager.class);
    }

    public CaseExecutionManager getCaseExecutionManager() {
        return this.getSession(CaseExecutionManager.class);
    }

    public CaseSentryPartManager getCaseSentryPartManager() {
        return this.getSession(CaseSentryPartManager.class);
    }

    public DecisionDefinitionManager getDecisionDefinitionManager() {
        return this.getSession(DecisionDefinitionManager.class);
    }

    public DecisionRequirementsDefinitionManager getDecisionRequirementsDefinitionManager() {
        return this.getSession(DecisionRequirementsDefinitionManager.class);
    }

    public HistoricDecisionInstanceManager getHistoricDecisionInstanceManager() {
        return this.getSession(HistoricDecisionInstanceManager.class);
    }

    public FilterManager getFilterManager() {
        return this.getSession(FilterManager.class);
    }

    public ExternalTaskManager getExternalTaskManager() {
        return this.getSession(ExternalTaskManager.class);
    }

    public void registerCommandContextListener(CommandContextListener commandContextListener) {
        if (!this.commandContextListeners.contains(commandContextListener)) {
            this.commandContextListeners.add(commandContextListener);
        }
    }

    public TransactionContext getTransactionContext() {
        return this.transactionContext;
    }

    public Map<Class<?>, Session> getSessions() {
        return this.sessions;
    }

    public FailedJobCommandFactory getFailedJobCommandFactory() {
        return this.failedJobCommandFactory;
    }

    public Authentication getAuthentication() {
        IdentityService identityService = this.processEngineConfiguration.getIdentityService();
        return identityService.getCurrentAuthentication();
    }

    public <T> T runWithoutAuthorization(Callable<T> runnable) {
        CommandContext commandContext = Context.getCommandContext();
        boolean authorizationEnabled = commandContext.isAuthorizationCheckEnabled();
        try {
            commandContext.disableAuthorizationCheck();
            T t = runnable.call();
            return t;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ProcessEngineException(e);
        }
        finally {
            if (authorizationEnabled) {
                commandContext.enableAuthorizationCheck();
            }
        }
    }

    public String getAuthenticatedUserId() {
        IdentityService identityService = this.processEngineConfiguration.getIdentityService();
        Authentication currentAuthentication = identityService.getCurrentAuthentication();
        if (currentAuthentication == null) {
            return null;
        }
        return currentAuthentication.getUserId();
    }

    public List<String> getAuthenticatedGroupIds() {
        IdentityService identityService = this.processEngineConfiguration.getIdentityService();
        Authentication currentAuthentication = identityService.getCurrentAuthentication();
        if (currentAuthentication == null) {
            return null;
        }
        return currentAuthentication.getGroupIds();
    }

    public void enableAuthorizationCheck() {
        this.authorizationCheckEnabled = true;
    }

    public void disableAuthorizationCheck() {
        this.authorizationCheckEnabled = false;
    }

    public boolean isAuthorizationCheckEnabled() {
        return this.authorizationCheckEnabled;
    }

    public void setAuthorizationCheckEnabled(boolean authorizationCheckEnabled) {
        this.authorizationCheckEnabled = authorizationCheckEnabled;
    }

    public void enableUserOperationLog() {
        this.userOperationLogEnabled = true;
    }

    public void disableUserOperationLog() {
        this.userOperationLogEnabled = false;
    }

    public boolean isUserOperationLogEnabled() {
        return this.userOperationLogEnabled;
    }

    public void setLogUserOperationEnabled(boolean userOperationLogEnabled) {
        this.userOperationLogEnabled = userOperationLogEnabled;
    }

    public void enableTenantCheck() {
        this.tenantCheckEnabled = true;
    }

    public void disableTenantCheck() {
        this.tenantCheckEnabled = false;
    }

    public void setTenantCheckEnabled(boolean tenantCheckEnabled) {
        this.tenantCheckEnabled = tenantCheckEnabled;
    }

    public boolean isTenantCheckEnabled() {
        return this.tenantCheckEnabled;
    }

    public JobEntity getCurrentJob() {
        return this.currentJob;
    }

    public void setCurrentJob(JobEntity currentJob) {
        this.currentJob = currentJob;
    }

    public boolean isRestrictUserOperationLogToAuthenticatedUsers() {
        return this.restrictUserOperationLogToAuthenticatedUsers;
    }

    public void setRestrictUserOperationLogToAuthenticatedUsers(boolean restrictUserOperationLogToAuthenticatedUsers) {
        this.restrictUserOperationLogToAuthenticatedUsers = restrictUserOperationLogToAuthenticatedUsers;
    }

    public String getOperationId() {
        if (!this.getOperationLogManager().isUserOperationLogEnabled()) {
            return null;
        }
        if (this.operationId == null) {
            this.operationId = Context.getProcessEngineConfiguration().getIdGenerator().getNextId();
        }
        return this.operationId;
    }

    public void setOperationId(String operationId) {
        this.operationId = operationId;
    }

    public OptimizeManager getOptimizeManager() {
        return this.getSession(OptimizeManager.class);
    }
}

