/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.management;

import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.cmd.ActivateJobCmd;
import org.camunda.bpm.engine.impl.cmd.CommandLogger;
import org.camunda.bpm.engine.impl.cmd.SuspendJobCmd;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.management.UpdateJobSuspensionStateBuilder;
import org.camunda.bpm.engine.management.UpdateJobSuspensionStateSelectBuilder;
import org.camunda.bpm.engine.management.UpdateJobSuspensionStateTenantBuilder;

public class UpdateJobSuspensionStateBuilderImpl
implements UpdateJobSuspensionStateBuilder,
UpdateJobSuspensionStateSelectBuilder,
UpdateJobSuspensionStateTenantBuilder {
    private static final CommandLogger LOG = ProcessEngineLogger.CMD_LOGGER;
    protected final CommandExecutor commandExecutor;
    protected String jobId;
    protected String jobDefinitionId;
    protected String processInstanceId;
    protected String processDefinitionKey;
    protected String processDefinitionId;
    protected String processDefinitionTenantId;
    protected boolean isProcessDefinitionTenantIdSet = false;

    public UpdateJobSuspensionStateBuilderImpl(CommandExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
    }

    public UpdateJobSuspensionStateBuilderImpl() {
        this(null);
    }

    @Override
    public UpdateJobSuspensionStateBuilderImpl byJobId(String jobId) {
        EnsureUtil.ensureNotNull("jobId", (Object)jobId);
        this.jobId = jobId;
        return this;
    }

    @Override
    public UpdateJobSuspensionStateBuilderImpl byJobDefinitionId(String jobDefinitionId) {
        EnsureUtil.ensureNotNull("jobDefinitionId", (Object)jobDefinitionId);
        this.jobDefinitionId = jobDefinitionId;
        return this;
    }

    @Override
    public UpdateJobSuspensionStateBuilderImpl byProcessInstanceId(String processInstanceId) {
        EnsureUtil.ensureNotNull("processInstanceId", (Object)processInstanceId);
        this.processInstanceId = processInstanceId;
        return this;
    }

    @Override
    public UpdateJobSuspensionStateBuilderImpl byProcessDefinitionId(String processDefinitionId) {
        EnsureUtil.ensureNotNull("processDefinitionId", (Object)processDefinitionId);
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Override
    public UpdateJobSuspensionStateBuilderImpl byProcessDefinitionKey(String processDefinitionKey) {
        EnsureUtil.ensureNotNull("processDefinitionKey", (Object)processDefinitionKey);
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    @Override
    public UpdateJobSuspensionStateBuilderImpl processDefinitionWithoutTenantId() {
        this.processDefinitionTenantId = null;
        this.isProcessDefinitionTenantIdSet = true;
        return this;
    }

    @Override
    public UpdateJobSuspensionStateBuilderImpl processDefinitionTenantId(String tenantId) {
        EnsureUtil.ensureNotNull("tenantId", (Object)tenantId);
        this.processDefinitionTenantId = tenantId;
        this.isProcessDefinitionTenantIdSet = true;
        return this;
    }

    @Override
    public void activate() {
        this.validateParameters();
        ActivateJobCmd command = new ActivateJobCmd(this);
        this.commandExecutor.execute(command);
    }

    @Override
    public void suspend() {
        this.validateParameters();
        SuspendJobCmd command = new SuspendJobCmd(this);
        this.commandExecutor.execute(command);
    }

    protected void validateParameters() {
        EnsureUtil.ensureOnlyOneNotNull("Need to specify either a job id, a job definition id, a process instance id, a process definition id or a process definition key.", this.jobId, this.jobDefinitionId, this.processInstanceId, this.processDefinitionId, this.processDefinitionKey);
        if (this.isProcessDefinitionTenantIdSet & (this.jobId != null || this.jobDefinitionId != null || this.processInstanceId != null || this.processDefinitionId != null)) {
            throw LOG.exceptionUpdateSuspensionStateForTenantOnlyByProcessDefinitionKey();
        }
        EnsureUtil.ensureNotNull("commandExecutor", (Object)this.commandExecutor);
    }

    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public String getProcessDefinitionTenantId() {
        return this.processDefinitionTenantId;
    }

    public boolean isProcessDefinitionTenantIdSet() {
        return this.isProcessDefinitionTenantIdSet;
    }

    public String getJobId() {
        return this.jobId;
    }

    public String getJobDefinitionId() {
        return this.jobDefinitionId;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }
}

