/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.migration.instance.parser;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.impl.jobexecutor.TimerDeclarationImpl;
import org.camunda.bpm.engine.impl.migration.instance.EmergingJobInstance;
import org.camunda.bpm.engine.impl.migration.instance.MigratingActivityInstance;
import org.camunda.bpm.engine.impl.migration.instance.MigratingTimerJobInstance;
import org.camunda.bpm.engine.impl.migration.instance.parser.MigratingDependentInstanceParseHandler;
import org.camunda.bpm.engine.impl.migration.instance.parser.MigratingInstanceParseContext;
import org.camunda.bpm.engine.impl.persistence.entity.JobDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.migration.MigrationInstruction;

public class ActivityInstanceJobHandler
implements MigratingDependentInstanceParseHandler<MigratingActivityInstance, List<JobEntity>> {
    @Override
    public void handle(MigratingInstanceParseContext parseContext, MigratingActivityInstance activityInstance, List<JobEntity> elements) {
        Map<String, TimerDeclarationImpl> sourceTimerDeclarationsInEventScope = this.getTimerDeclarationsByTriggeringActivity(activityInstance.getSourceScope());
        Map<String, TimerDeclarationImpl> targetTimerDeclarationsInEventScope = this.getTimerDeclarationsByTriggeringActivity(activityInstance.getTargetScope());
        for (JobEntity job : elements) {
            if (!ActivityInstanceJobHandler.isTimerJob(job)) continue;
            MigrationInstruction migrationInstruction = parseContext.findSingleMigrationInstruction(job.getActivityId());
            ActivityImpl targetActivity = parseContext.getTargetActivity(migrationInstruction);
            if (targetActivity != null && activityInstance.migratesTo(targetActivity.getEventScope())) {
                JobDefinitionEntity targetJobDefinitionEntity = parseContext.getTargetJobDefinition(targetActivity.getActivityId(), job.getJobHandlerType());
                TimerDeclarationImpl targetTimerDeclaration = targetTimerDeclarationsInEventScope.remove(targetActivity.getId());
                MigratingTimerJobInstance migratingTimerJobInstance = new MigratingTimerJobInstance(job, targetJobDefinitionEntity, targetActivity, migrationInstruction.isUpdateEventTrigger(), targetTimerDeclaration);
                activityInstance.addMigratingDependentInstance(migratingTimerJobInstance);
                parseContext.submit(migratingTimerJobInstance);
            } else {
                MigratingTimerJobInstance removingJobInstance = new MigratingTimerJobInstance(job);
                activityInstance.addRemovingDependentInstance(removingJobInstance);
                parseContext.submit(removingJobInstance);
            }
            parseContext.consume(job);
        }
        if (activityInstance.migrates()) {
            this.addEmergingTimerJobs(parseContext, activityInstance, sourceTimerDeclarationsInEventScope, targetTimerDeclarationsInEventScope);
        }
    }

    protected static boolean isTimerJob(JobEntity job) {
        return job != null && job.getType().equals("timer");
    }

    protected void addEmergingTimerJobs(MigratingInstanceParseContext parseContext, MigratingActivityInstance activityInstance, Map<String, TimerDeclarationImpl> sourceTimerDeclarationsInEventScope, Map<String, TimerDeclarationImpl> targetTimerDeclarationsInEventScope) {
        for (TimerDeclarationImpl targetTimerDeclaration : targetTimerDeclarationsInEventScope.values()) {
            if (this.isNonInterruptingTimerTriggeredAlready(parseContext, sourceTimerDeclarationsInEventScope, targetTimerDeclaration)) continue;
            activityInstance.addEmergingDependentInstance(new EmergingJobInstance(targetTimerDeclaration));
        }
    }

    protected boolean isNonInterruptingTimerTriggeredAlready(MigratingInstanceParseContext parseContext, Map<String, TimerDeclarationImpl> sourceTimerDeclarationsInEventScope, TimerDeclarationImpl targetTimerDeclaration) {
        if (targetTimerDeclaration.isInterruptingTimer() || targetTimerDeclaration.getJobHandlerType() != "timer-transition" || sourceTimerDeclarationsInEventScope.values().size() == 0) {
            return false;
        }
        for (TimerDeclarationImpl sourceTimerDeclaration : sourceTimerDeclarationsInEventScope.values()) {
            MigrationInstruction migrationInstruction = parseContext.findSingleMigrationInstruction(sourceTimerDeclaration.getActivityId());
            ActivityImpl targetActivity = parseContext.getTargetActivity(migrationInstruction);
            if (targetActivity == null || !targetTimerDeclaration.getActivityId().equals(targetActivity.getActivityId())) continue;
            return true;
        }
        return false;
    }

    protected Map<String, TimerDeclarationImpl> getTimerDeclarationsByTriggeringActivity(ScopeImpl scope) {
        return new HashMap<String, TimerDeclarationImpl>(TimerDeclarationImpl.getDeclarationsForScope(scope));
    }
}

