/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.camunda.bpm.engine.impl.Direction;
import org.camunda.bpm.engine.impl.JobQueryImpl;
import org.camunda.bpm.engine.impl.JobQueryProperty;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.QueryOrderingProperty;
import org.camunda.bpm.engine.impl.cfg.TransactionListener;
import org.camunda.bpm.engine.impl.cfg.TransactionState;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.db.ListQueryParameterObject;
import org.camunda.bpm.engine.impl.jobexecutor.ExclusiveJobAddedNotification;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutor;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutorContext;
import org.camunda.bpm.engine.impl.jobexecutor.MessageAddedNotification;
import org.camunda.bpm.engine.impl.persistence.AbstractManager;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.persistence.entity.MessageEntity;
import org.camunda.bpm.engine.impl.persistence.entity.SuspensionState;
import org.camunda.bpm.engine.impl.persistence.entity.TimerEntity;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.runtime.Job;

public class JobManager
extends AbstractManager {
    public static QueryOrderingProperty JOB_PRIORITY_ORDERING_PROPERTY = new QueryOrderingProperty(null, JobQueryProperty.PRIORITY);
    public static QueryOrderingProperty JOB_TYPE_ORDERING_PROPERTY = new QueryOrderingProperty(null, JobQueryProperty.TYPE);
    public static QueryOrderingProperty JOB_DUEDATE_ORDERING_PROPERTY = new QueryOrderingProperty(null, JobQueryProperty.DUEDATE);

    public void updateJob(JobEntity job) {
        this.getDbEntityManager().merge(job);
    }

    public void insertJob(JobEntity job) {
        job.setCreateTime(ClockUtil.getCurrentTime());
        this.getDbEntityManager().insert(job);
        this.getHistoricJobLogManager().fireJobCreatedEvent(job);
    }

    public void deleteJob(JobEntity job) {
        this.deleteJob(job, true);
    }

    public void deleteJob(JobEntity job, boolean fireDeleteEvent) {
        this.getDbEntityManager().delete(job);
        if (fireDeleteEvent) {
            this.getHistoricJobLogManager().fireJobDeletedEvent(job);
        }
    }

    public void insertAndHintJobExecutor(JobEntity jobEntity) {
        jobEntity.insert();
        if (Context.getProcessEngineConfiguration().isHintJobExecutor()) {
            this.hintJobExecutor(jobEntity);
        }
    }

    public void send(MessageEntity message) {
        message.insert();
        if (Context.getProcessEngineConfiguration().isHintJobExecutor()) {
            this.hintJobExecutor(message);
        }
    }

    public void schedule(TimerEntity timer) {
        Date duedate = timer.getDuedate();
        EnsureUtil.ensureNotNull("duedate", (Object)duedate);
        timer.insert();
        this.hintJobExecutorIfNeeded(timer, duedate);
    }

    public void reschedule(JobEntity jobEntity, Date newDuedate) {
        jobEntity.init(Context.getCommandContext());
        jobEntity.setSuspensionState(SuspensionState.ACTIVE.getStateCode());
        jobEntity.setDuedate(newDuedate);
        this.hintJobExecutorIfNeeded(jobEntity, newDuedate);
    }

    private void hintJobExecutorIfNeeded(JobEntity jobEntity, Date duedate) {
        JobExecutor jobExecutor = Context.getProcessEngineConfiguration().getJobExecutor();
        int waitTimeInMillis = jobExecutor.getWaitTimeInMillis();
        if (duedate.getTime() < ClockUtil.getCurrentTime().getTime() + (long)waitTimeInMillis) {
            this.hintJobExecutor(jobEntity);
        }
    }

    protected void hintJobExecutor(JobEntity job) {
        JobExecutor jobExecutor = Context.getProcessEngineConfiguration().getJobExecutor();
        if (!jobExecutor.isActive()) {
            return;
        }
        JobExecutorContext jobExecutorContext = Context.getJobExecutorContext();
        TransactionListener transactionListener = null;
        if (!job.isSuspended() && job.isExclusive() && jobExecutorContext != null && jobExecutorContext.isExecutingExclusiveJob() && this.areInSameProcessInstance(job, jobExecutorContext.getCurrentJob())) {
            Date currentTime = ClockUtil.getCurrentTime();
            job.setLockExpirationTime(new Date(currentTime.getTime() + (long)jobExecutor.getLockTimeInMillis()));
            job.setLockOwner(jobExecutor.getLockOwner());
            transactionListener = new ExclusiveJobAddedNotification(job.getId(), jobExecutorContext);
        } else {
            transactionListener = new MessageAddedNotification(jobExecutor);
        }
        Context.getCommandContext().getTransactionContext().addTransactionListener(TransactionState.COMMITTED, transactionListener);
    }

    protected boolean areInSameProcessInstance(JobEntity job1, JobEntity job2) {
        if (job1 == null || job2 == null) {
            return false;
        }
        String instance1 = job1.getProcessInstanceId();
        String instance2 = job2.getProcessInstanceId();
        return instance1 != null && instance1.equals(instance2);
    }

    public void cancelTimers(ExecutionEntity execution) {
        List<TimerEntity> timers = Context.getCommandContext().getJobManager().findTimersByExecutionId(execution.getId());
        for (TimerEntity timer : timers) {
            timer.delete();
        }
    }

    public JobEntity findJobById(String jobId) {
        return (JobEntity)this.getDbEntityManager().selectOne("selectJob", jobId);
    }

    public List<JobEntity> findNextJobsToExecute(Page page) {
        Set<String> registeredDeployments;
        HashMap<String, Object> params = new HashMap<String, Object>();
        Date now = ClockUtil.getCurrentTime();
        params.put("now", now);
        params.put("deploymentAware", Context.getProcessEngineConfiguration().isJobExecutorDeploymentAware());
        if (Context.getProcessEngineConfiguration().isJobExecutorDeploymentAware() && !(registeredDeployments = Context.getProcessEngineConfiguration().getRegisteredDeployments()).isEmpty()) {
            params.put("deploymentIds", registeredDeployments);
        }
        ArrayList<QueryOrderingProperty> orderingProperties = new ArrayList<QueryOrderingProperty>();
        if (Context.getProcessEngineConfiguration().isJobExecutorAcquireByPriority()) {
            orderingProperties.add(JOB_PRIORITY_ORDERING_PROPERTY);
        }
        if (Context.getProcessEngineConfiguration().isJobExecutorPreferTimerJobs()) {
            orderingProperties.add(JOB_TYPE_ORDERING_PROPERTY);
        }
        if (Context.getProcessEngineConfiguration().isJobExecutorAcquireByDueDate()) {
            orderingProperties.add(JOB_DUEDATE_ORDERING_PROPERTY);
        }
        params.put("orderingProperties", orderingProperties);
        params.put("applyOrdering", !orderingProperties.isEmpty());
        return this.getDbEntityManager().selectList("selectNextJobsToExecute", params, page);
    }

    public List<JobEntity> findJobsByExecutionId(String executionId) {
        return this.getDbEntityManager().selectList("selectJobsByExecutionId", executionId);
    }

    public List<JobEntity> findJobsByProcessInstanceId(String processInstanceId) {
        return this.getDbEntityManager().selectList("selectJobsByProcessInstanceId", processInstanceId);
    }

    public List<JobEntity> findJobsByJobDefinitionId(String jobDefinitionId) {
        return this.getDbEntityManager().selectList("selectJobsByJobDefinitionId", jobDefinitionId);
    }

    public List<Job> findJobsByHandlerType(String handlerType) {
        return this.getDbEntityManager().selectList("selectJobsByHandlerType", handlerType);
    }

    public List<TimerEntity> findUnlockedTimersByDuedate(Date duedate, Page page) {
        String query = "selectUnlockedTimersByDuedate";
        return this.getDbEntityManager().selectList("selectUnlockedTimersByDuedate", duedate, page);
    }

    public List<TimerEntity> findTimersByExecutionId(String executionId) {
        return this.getDbEntityManager().selectList("selectTimersByExecutionId", executionId);
    }

    public List<Job> findJobsByQueryCriteria(JobQueryImpl jobQuery, Page page) {
        this.configureQuery(jobQuery);
        return this.getDbEntityManager().selectList("selectJobByQueryCriteria", jobQuery, page);
    }

    public List<JobEntity> findJobsByConfiguration(String jobHandlerType, String jobHandlerConfiguration, String tenantId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("handlerType", jobHandlerType);
        params.put("handlerConfiguration", jobHandlerConfiguration);
        params.put("tenantId", tenantId);
        if ("timer-intermediate-transition".equals(jobHandlerType) || "timer-transition".equals(jobHandlerType) || "timer-start-event".equals(jobHandlerType) || "timer-start-event-subprocess".equals(jobHandlerType)) {
            String queryValue = jobHandlerConfiguration + "$" + "followUpJobCreated";
            params.put("handlerConfigurationWithFollowUpJobCreatedProperty", queryValue);
        }
        return this.getDbEntityManager().selectList("selectJobsByConfiguration", params);
    }

    public long findJobCountByQueryCriteria(JobQueryImpl jobQuery) {
        this.configureQuery(jobQuery);
        return (Long)this.getDbEntityManager().selectOne("selectJobCountByQueryCriteria", jobQuery);
    }

    public void updateJobSuspensionStateById(String jobId, SuspensionState suspensionState) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("jobId", jobId);
        parameters.put("suspensionState", suspensionState.getStateCode());
        this.getDbEntityManager().update(JobEntity.class, "updateJobSuspensionStateByParameters", this.configureParameterizedQuery(parameters));
    }

    public void updateJobSuspensionStateByJobDefinitionId(String jobDefinitionId, SuspensionState suspensionState) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("jobDefinitionId", jobDefinitionId);
        parameters.put("suspensionState", suspensionState.getStateCode());
        this.getDbEntityManager().update(JobEntity.class, "updateJobSuspensionStateByParameters", this.configureParameterizedQuery(parameters));
    }

    public void updateJobSuspensionStateByProcessInstanceId(String processInstanceId, SuspensionState suspensionState) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("processInstanceId", processInstanceId);
        parameters.put("suspensionState", suspensionState.getStateCode());
        this.getDbEntityManager().update(JobEntity.class, "updateJobSuspensionStateByParameters", this.configureParameterizedQuery(parameters));
    }

    public void updateJobSuspensionStateByProcessDefinitionId(String processDefinitionId, SuspensionState suspensionState) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("processDefinitionId", processDefinitionId);
        parameters.put("suspensionState", suspensionState.getStateCode());
        this.getDbEntityManager().update(JobEntity.class, "updateJobSuspensionStateByParameters", this.configureParameterizedQuery(parameters));
    }

    public void updateStartTimerJobSuspensionStateByProcessDefinitionId(String processDefinitionId, SuspensionState suspensionState) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("processDefinitionId", processDefinitionId);
        parameters.put("suspensionState", suspensionState.getStateCode());
        parameters.put("handlerType", "timer-start-event");
        this.getDbEntityManager().update(JobEntity.class, "updateJobSuspensionStateByParameters", this.configureParameterizedQuery(parameters));
    }

    public void updateJobSuspensionStateByProcessDefinitionKey(String processDefinitionKey, SuspensionState suspensionState) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("processDefinitionKey", processDefinitionKey);
        parameters.put("isProcessDefinitionTenantIdSet", false);
        parameters.put("suspensionState", suspensionState.getStateCode());
        this.getDbEntityManager().update(JobEntity.class, "updateJobSuspensionStateByParameters", this.configureParameterizedQuery(parameters));
    }

    public void updateJobSuspensionStateByProcessDefinitionKeyAndTenantId(String processDefinitionKey, String processDefinitionTenantId, SuspensionState suspensionState) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("processDefinitionKey", processDefinitionKey);
        parameters.put("isProcessDefinitionTenantIdSet", true);
        parameters.put("processDefinitionTenantId", processDefinitionTenantId);
        parameters.put("suspensionState", suspensionState.getStateCode());
        this.getDbEntityManager().update(JobEntity.class, "updateJobSuspensionStateByParameters", this.configureParameterizedQuery(parameters));
    }

    public void updateStartTimerJobSuspensionStateByProcessDefinitionKey(String processDefinitionKey, SuspensionState suspensionState) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("processDefinitionKey", processDefinitionKey);
        parameters.put("isProcessDefinitionTenantIdSet", false);
        parameters.put("suspensionState", suspensionState.getStateCode());
        parameters.put("handlerType", "timer-start-event");
        this.getDbEntityManager().update(JobEntity.class, "updateJobSuspensionStateByParameters", this.configureParameterizedQuery(parameters));
    }

    public void updateStartTimerJobSuspensionStateByProcessDefinitionKeyAndTenantId(String processDefinitionKey, String processDefinitionTenantId, SuspensionState suspensionState) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("processDefinitionKey", processDefinitionKey);
        parameters.put("isProcessDefinitionTenantIdSet", true);
        parameters.put("processDefinitionTenantId", processDefinitionTenantId);
        parameters.put("suspensionState", suspensionState.getStateCode());
        parameters.put("handlerType", "timer-start-event");
        this.getDbEntityManager().update(JobEntity.class, "updateJobSuspensionStateByParameters", this.configureParameterizedQuery(parameters));
    }

    public void updateFailedJobRetriesByJobDefinitionId(String jobDefinitionId, int retries) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("jobDefinitionId", jobDefinitionId);
        parameters.put("retries", retries);
        this.getDbEntityManager().update(JobEntity.class, "updateFailedJobRetriesByParameters", parameters);
    }

    public void updateJobPriorityByDefinitionId(String jobDefinitionId, long priority) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("jobDefinitionId", jobDefinitionId);
        parameters.put("priority", priority);
        this.getDbEntityManager().update(JobEntity.class, "updateJobPriorityByDefinitionId", parameters);
    }

    protected void configureQuery(JobQueryImpl query) {
        this.getAuthorizationManager().configureJobQuery(query);
        this.getTenantManager().configureQuery(query);
    }

    protected ListQueryParameterObject configureParameterizedQuery(Object parameter) {
        return this.getTenantManager().configureQuery(parameter);
    }

    static {
        JOB_PRIORITY_ORDERING_PROPERTY.setDirection(Direction.DESCENDING);
        JOB_TYPE_ORDERING_PROPERTY.setDirection(Direction.DESCENDING);
        JOB_DUEDATE_ORDERING_PROPERTY.setDirection(Direction.ASCENDING);
    }
}

