/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.context;

import java.util.Stack;
import java.util.concurrent.Callable;
import org.camunda.bpm.application.InvocationContext;
import org.camunda.bpm.application.ProcessApplicationInterface;
import org.camunda.bpm.application.ProcessApplicationReference;
import org.camunda.bpm.application.ProcessApplicationUnavailableException;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cmmn.entity.runtime.CaseExecutionEntity;
import org.camunda.bpm.engine.impl.context.BpmnExecutionContext;
import org.camunda.bpm.engine.impl.context.CaseExecutionContext;
import org.camunda.bpm.engine.impl.context.CoreExecutionContext;
import org.camunda.bpm.engine.impl.context.ExecutionContext;
import org.camunda.bpm.engine.impl.context.ProcessApplicationClassloaderInterceptor;
import org.camunda.bpm.engine.impl.core.instance.CoreExecution;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandInvocationContext;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutorContext;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;

public class Context {
    protected static ThreadLocal<Stack<CommandContext>> commandContextThreadLocal = new ThreadLocal();
    protected static ThreadLocal<Stack<CommandInvocationContext>> commandInvocationContextThreadLocal = new ThreadLocal();
    protected static ThreadLocal<Stack<ProcessEngineConfigurationImpl>> processEngineConfigurationStackThreadLocal = new ThreadLocal();
    protected static ThreadLocal<Stack<CoreExecutionContext<? extends CoreExecution>>> executionContextStackThreadLocal = new ThreadLocal();
    protected static ThreadLocal<JobExecutorContext> jobExecutorContextThreadLocal = new ThreadLocal();
    protected static ThreadLocal<Stack<ProcessApplicationReference>> processApplicationContext = new ThreadLocal();

    public static CommandContext getCommandContext() {
        Stack stack = Context.getStack(commandContextThreadLocal);
        if (stack.isEmpty()) {
            return null;
        }
        return (CommandContext)stack.peek();
    }

    public static void setCommandContext(CommandContext commandContext) {
        Context.getStack(commandContextThreadLocal).push(commandContext);
    }

    public static void removeCommandContext() {
        Context.getStack(commandContextThreadLocal).pop();
    }

    public static CommandInvocationContext getCommandInvocationContext() {
        Stack stack = Context.getStack(commandInvocationContextThreadLocal);
        if (stack.isEmpty()) {
            return null;
        }
        return (CommandInvocationContext)stack.peek();
    }

    public static void setCommandInvocationContext(CommandInvocationContext commandInvocationContext) {
        Context.getStack(commandInvocationContextThreadLocal).push(commandInvocationContext);
    }

    public static void removeCommandInvocationContext() {
        Context.getStack(commandInvocationContextThreadLocal).pop();
    }

    public static ProcessEngineConfigurationImpl getProcessEngineConfiguration() {
        Stack stack = Context.getStack(processEngineConfigurationStackThreadLocal);
        if (stack.isEmpty()) {
            return null;
        }
        return (ProcessEngineConfigurationImpl)stack.peek();
    }

    public static void setProcessEngineConfiguration(ProcessEngineConfigurationImpl processEngineConfiguration) {
        Context.getStack(processEngineConfigurationStackThreadLocal).push(processEngineConfiguration);
    }

    public static void removeProcessEngineConfiguration() {
        Context.getStack(processEngineConfigurationStackThreadLocal).pop();
    }

    @Deprecated
    public static ExecutionContext getExecutionContext() {
        return Context.getBpmnExecutionContext();
    }

    public static BpmnExecutionContext getBpmnExecutionContext() {
        return (BpmnExecutionContext)Context.getCoreExecutionContext();
    }

    public static CaseExecutionContext getCaseExecutionContext() {
        return (CaseExecutionContext)Context.getCoreExecutionContext();
    }

    public static CoreExecutionContext<? extends CoreExecution> getCoreExecutionContext() {
        Stack stack = Context.getStack(executionContextStackThreadLocal);
        if (stack == null || stack.isEmpty()) {
            return null;
        }
        return (CoreExecutionContext)stack.peek();
    }

    public static void setExecutionContext(ExecutionEntity execution) {
        Context.getStack(executionContextStackThreadLocal).push(new BpmnExecutionContext(execution));
    }

    public static void setExecutionContext(CaseExecutionEntity execution) {
        Context.getStack(executionContextStackThreadLocal).push(new CaseExecutionContext(execution));
    }

    public static void removeExecutionContext() {
        Context.getStack(executionContextStackThreadLocal).pop();
    }

    protected static <T> Stack<T> getStack(ThreadLocal<Stack<T>> threadLocal) {
        Stack<Object> stack = threadLocal.get();
        if (stack == null) {
            stack = new Stack();
            threadLocal.set(stack);
        }
        return stack;
    }

    public static JobExecutorContext getJobExecutorContext() {
        return jobExecutorContextThreadLocal.get();
    }

    public static void setJobExecutorContext(JobExecutorContext jobExecutorContext) {
        jobExecutorContextThreadLocal.set(jobExecutorContext);
    }

    public static void removeJobExecutorContext() {
        jobExecutorContextThreadLocal.remove();
    }

    public static ProcessApplicationReference getCurrentProcessApplication() {
        Stack stack = Context.getStack(processApplicationContext);
        if (stack.isEmpty()) {
            return null;
        }
        return (ProcessApplicationReference)stack.peek();
    }

    public static void setCurrentProcessApplication(ProcessApplicationReference reference) {
        Stack stack = Context.getStack(processApplicationContext);
        stack.push(reference);
    }

    public static void removeCurrentProcessApplication() {
        Stack stack = Context.getStack(processApplicationContext);
        stack.pop();
    }

    public static <T> T executeWithinProcessApplication(Callable<T> callback, ProcessApplicationReference processApplicationReference) {
        return Context.executeWithinProcessApplication(callback, processApplicationReference, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T executeWithinProcessApplication(Callable<T> callback, ProcessApplicationReference processApplicationReference, InvocationContext invocationContext) {
        String paName = processApplicationReference.getName();
        try {
            ProcessApplicationInterface processApplication = processApplicationReference.getProcessApplication();
            Context.setCurrentProcessApplication(processApplicationReference);
            try {
                ProcessApplicationClassloaderInterceptor<T> wrappedCallback = new ProcessApplicationClassloaderInterceptor<T>(callback);
                T t = processApplication.execute(wrappedCallback, invocationContext);
                return t;
            }
            catch (Exception e) {
                if (e.getCause() == null) throw new ProcessEngineException("Unexpected exeption while executing within process application ", e);
                if (!(e.getCause() instanceof RuntimeException)) throw new ProcessEngineException("Unexpected exeption while executing within process application ", e);
                throw (RuntimeException)e.getCause();
            }
            finally {
                Context.removeCurrentProcessApplication();
            }
        }
        catch (ProcessApplicationUnavailableException e) {
            throw new ProcessEngineException("Cannot switch to process application '" + paName + "' for execution: " + e.getMessage(), e);
        }
    }
}

