/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.scripting.engine;

import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import org.camunda.bpm.application.AbstractProcessApplication;
import org.camunda.bpm.application.ProcessApplicationInterface;
import org.camunda.bpm.application.ProcessApplicationReference;
import org.camunda.bpm.application.ProcessApplicationUnavailableException;
import org.camunda.bpm.dmn.engine.impl.spi.el.DmnScriptEngineResolver;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.delegate.VariableScope;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.scripting.engine.ScriptBindingsFactory;
import org.camunda.bpm.engine.impl.scripting.engine.ScriptEngineResolver;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class ScriptingEngines
implements DmnScriptEngineResolver {
    public static final String DEFAULT_SCRIPTING_LANGUAGE = "juel";
    public static final String GROOVY_SCRIPTING_LANGUAGE = "groovy";
    protected ScriptEngineResolver scriptEngineResolver;
    protected ScriptBindingsFactory scriptBindingsFactory;
    protected boolean enableScriptEngineCaching = true;

    public ScriptingEngines(ScriptBindingsFactory scriptBindingsFactory) {
        this(new ScriptEngineManager());
        this.scriptBindingsFactory = scriptBindingsFactory;
    }

    public ScriptingEngines(ScriptEngineManager scriptEngineManager) {
        this.scriptEngineResolver = new ScriptEngineResolver(scriptEngineManager);
    }

    public boolean isEnableScriptEngineCaching() {
        return this.enableScriptEngineCaching;
    }

    public void setEnableScriptEngineCaching(boolean enableScriptEngineCaching) {
        this.enableScriptEngineCaching = enableScriptEngineCaching;
    }

    public ScriptEngineManager getScriptEngineManager() {
        return this.scriptEngineResolver.getScriptEngineManager();
    }

    public ScriptingEngines addScriptEngineFactory(ScriptEngineFactory scriptEngineFactory) {
        this.scriptEngineResolver.addScriptEngineFactory(scriptEngineFactory);
        return this;
    }

    public ScriptEngine getScriptEngineForLanguage(String language) {
        if (language != null) {
            language = language.toLowerCase();
        }
        ProcessApplicationReference pa = Context.getCurrentProcessApplication();
        ProcessEngineConfigurationImpl config = Context.getProcessEngineConfiguration();
        ScriptEngine engine = null;
        if (config.isEnableFetchScriptEngineFromProcessApplication() && pa != null) {
            engine = this.getPaScriptEngine(language, pa);
        }
        if (engine == null) {
            engine = this.getGlobalScriptEngine(language);
        }
        return engine;
    }

    protected ScriptEngine getPaScriptEngine(String language, ProcessApplicationReference pa) {
        try {
            ProcessApplicationInterface processApplication = pa.getProcessApplication();
            ProcessApplicationInterface rawObject = processApplication.getRawObject();
            if (rawObject instanceof AbstractProcessApplication) {
                AbstractProcessApplication abstractProcessApplication = (AbstractProcessApplication)rawObject;
                return abstractProcessApplication.getScriptEngineForName(language, this.enableScriptEngineCaching);
            }
            return null;
        }
        catch (ProcessApplicationUnavailableException e) {
            throw new ProcessEngineException("Process Application is unavailable.", e);
        }
    }

    protected ScriptEngine getGlobalScriptEngine(String language) {
        ScriptEngine scriptEngine = this.scriptEngineResolver.getScriptEngine(language, this.enableScriptEngineCaching);
        EnsureUtil.ensureNotNull("Can't find scripting engine for '" + language + "'", "scriptEngine", (Object)scriptEngine);
        return scriptEngine;
    }

    public Bindings createBindings(ScriptEngine scriptEngine, VariableScope variableScope) {
        return this.scriptBindingsFactory.createBindings(variableScope, scriptEngine.createBindings());
    }

    public ScriptBindingsFactory getScriptBindingsFactory() {
        return this.scriptBindingsFactory;
    }

    public void setScriptBindingsFactory(ScriptBindingsFactory scriptBindingsFactory) {
        this.scriptBindingsFactory = scriptBindingsFactory;
    }
}

