/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd.batch;

import java.util.List;
import org.camunda.bpm.engine.impl.batch.BatchConfiguration;
import org.camunda.bpm.engine.impl.batch.BatchEntity;
import org.camunda.bpm.engine.impl.batch.BatchJobHandler;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cmd.batch.AbstractBatchCmd;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.util.BatchUtil;

public abstract class AbstractIDBasedBatchCmd<T>
extends AbstractBatchCmd<T> {
    protected BatchEntity createBatch(CommandContext commandContext, List<String> ids) {
        ProcessEngineConfigurationImpl processEngineConfiguration = commandContext.getProcessEngineConfiguration();
        BatchJobHandler batchJobHandler = this.getBatchJobHandler(processEngineConfiguration);
        BatchConfiguration configuration = this.getAbstractIdsBatchConfiguration(ids);
        BatchEntity batch = new BatchEntity();
        batch.setType(batchJobHandler.getType());
        batch.setTotalJobs(BatchUtil.calculateBatchSize(processEngineConfiguration, configuration));
        batch.setBatchJobsPerSeed(processEngineConfiguration.getBatchJobsPerSeed());
        batch.setInvocationsPerBatchJob(processEngineConfiguration.getInvocationsPerBatchJob());
        batch.setConfigurationBytes(batchJobHandler.writeConfiguration(configuration));
        commandContext.getBatchManager().insertBatch(batch);
        return batch;
    }

    protected abstract BatchConfiguration getAbstractIdsBatchConfiguration(List<String> var1);

    protected abstract BatchJobHandler getBatchJobHandler(ProcessEngineConfigurationImpl var1);
}

