/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd.batch.removaltime;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.authorization.BatchPermissions;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.batch.history.HistoricBatch;
import org.camunda.bpm.engine.batch.history.HistoricBatchQuery;
import org.camunda.bpm.engine.impl.batch.BatchConfiguration;
import org.camunda.bpm.engine.impl.batch.BatchEntity;
import org.camunda.bpm.engine.impl.batch.BatchJobHandler;
import org.camunda.bpm.engine.impl.batch.removaltime.SetRemovalTimeBatchConfiguration;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cmd.batch.AbstractIDBasedBatchCmd;
import org.camunda.bpm.engine.impl.history.SetRemovalTimeToHistoricBatchesBuilderImpl;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyChange;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class SetRemovalTimeToHistoricBatchesCmd
extends AbstractIDBasedBatchCmd<Batch> {
    protected SetRemovalTimeToHistoricBatchesBuilderImpl builder;

    public SetRemovalTimeToHistoricBatchesCmd(SetRemovalTimeToHistoricBatchesBuilderImpl builder) {
        this.builder = builder;
    }

    @Override
    public Batch execute(CommandContext commandContext) {
        HashSet<String> historicBatchIds = new HashSet<String>();
        List<String> instanceIds = this.builder.getIds();
        HistoricBatchQuery instanceQuery = this.builder.getQuery();
        if (instanceQuery == null && instanceIds == null) {
            throw new BadUserRequestException("Either query nor ids provided.");
        }
        if (instanceQuery != null) {
            for (HistoricBatch historicBatch : instanceQuery.list()) {
                historicBatchIds.add(historicBatch.getId());
            }
        }
        if (instanceIds != null) {
            historicBatchIds.addAll(this.findHistoricInstanceIds(instanceIds, commandContext));
        }
        EnsureUtil.ensureNotNull(BadUserRequestException.class, "removalTime", (Object)this.builder.getMode());
        EnsureUtil.ensureNotEmpty(BadUserRequestException.class, "historicBatches", historicBatchIds);
        this.checkAuthorizations(commandContext, BatchPermissions.CREATE_BATCH_SET_REMOVAL_TIME);
        this.writeUserOperationLog(commandContext, historicBatchIds.size(), this.builder.getMode(), this.builder.getRemovalTime(), true);
        BatchEntity batch = this.createBatch(commandContext, new ArrayList<String>(historicBatchIds));
        batch.createSeedJobDefinition();
        batch.createMonitorJobDefinition();
        batch.createBatchJobDefinition();
        batch.fireHistoricStartEvent();
        batch.createSeedJob();
        return batch;
    }

    protected List<String> findHistoricInstanceIds(List<String> instanceIds, CommandContext commandContext) {
        ArrayList<String> ids = new ArrayList<String>();
        for (String instanceId : instanceIds) {
            HistoricBatch batch = (HistoricBatch)this.createHistoricBatchQuery(commandContext).batchId(instanceId).singleResult();
            if (batch == null) continue;
            ids.add(batch.getId());
        }
        return ids;
    }

    protected HistoricBatchQuery createHistoricBatchQuery(CommandContext commandContext) {
        return commandContext.getProcessEngineConfiguration().getHistoryService().createHistoricBatchQuery();
    }

    protected void writeUserOperationLog(CommandContext commandContext, int numInstances, SetRemovalTimeToHistoricBatchesBuilderImpl.Mode mode, Date removalTime, boolean async) {
        ArrayList<PropertyChange> propertyChanges = new ArrayList<PropertyChange>();
        propertyChanges.add(new PropertyChange("mode", null, (Object)mode));
        propertyChanges.add(new PropertyChange("removalTime", null, removalTime));
        propertyChanges.add(new PropertyChange("nrOfInstances", null, numInstances));
        propertyChanges.add(new PropertyChange("async", null, async));
        commandContext.getOperationLogManager().logBatchOperation("SetRemovalTime", propertyChanges);
    }

    @Override
    protected BatchConfiguration getAbstractIdsBatchConfiguration(List<String> ids) {
        return new SetRemovalTimeBatchConfiguration(ids).setHasRemovalTime(this.hasRemovalTime(this.builder.getMode())).setRemovalTime(this.builder.getRemovalTime());
    }

    protected boolean hasRemovalTime(SetRemovalTimeToHistoricBatchesBuilderImpl.Mode mode) {
        return this.builder.getMode() == SetRemovalTimeToHistoricBatchesBuilderImpl.Mode.ABSOLUTE_REMOVAL_TIME || this.builder.getMode() == SetRemovalTimeToHistoricBatchesBuilderImpl.Mode.CLEARED_REMOVAL_TIME;
    }

    @Override
    protected BatchJobHandler getBatchJobHandler(ProcessEngineConfigurationImpl processEngineConfiguration) {
        return processEngineConfiguration.getBatchHandlers().get("batch-set-removal-time");
    }
}

