/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd.batch.removaltime;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.authorization.BatchPermissions;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.history.HistoricDecisionInstance;
import org.camunda.bpm.engine.history.HistoricDecisionInstanceQuery;
import org.camunda.bpm.engine.impl.batch.BatchConfiguration;
import org.camunda.bpm.engine.impl.batch.BatchEntity;
import org.camunda.bpm.engine.impl.batch.BatchJobHandler;
import org.camunda.bpm.engine.impl.batch.removaltime.SetRemovalTimeBatchConfiguration;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cmd.batch.AbstractIDBasedBatchCmd;
import org.camunda.bpm.engine.impl.history.SetRemovalTimeToHistoricDecisionInstancesBuilderImpl;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyChange;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class SetRemovalTimeToHistoricDecisionInstancesCmd
extends AbstractIDBasedBatchCmd<Batch> {
    protected SetRemovalTimeToHistoricDecisionInstancesBuilderImpl builder;

    public SetRemovalTimeToHistoricDecisionInstancesCmd(SetRemovalTimeToHistoricDecisionInstancesBuilderImpl builder) {
        this.builder = builder;
    }

    @Override
    public Batch execute(CommandContext commandContext) {
        HashSet<String> historicDecisionInstanceIds = new HashSet<String>();
        List<String> instanceIds = this.builder.getIds();
        HistoricDecisionInstanceQuery instanceQuery = this.builder.getQuery();
        if (instanceQuery == null && instanceIds == null) {
            throw new BadUserRequestException("Either query nor ids provided.");
        }
        if (instanceQuery != null) {
            for (HistoricDecisionInstance historicDecisionInstance : instanceQuery.list()) {
                historicDecisionInstanceIds.add(historicDecisionInstance.getId());
            }
        }
        if (instanceIds != null) {
            historicDecisionInstanceIds.addAll(this.findHistoricInstanceIds(instanceIds, commandContext));
        }
        EnsureUtil.ensureNotNull(BadUserRequestException.class, "removalTime", (Object)this.builder.getMode());
        EnsureUtil.ensureNotEmpty(BadUserRequestException.class, "historicDecisionInstances", historicDecisionInstanceIds);
        this.checkAuthorizations(commandContext, BatchPermissions.CREATE_BATCH_SET_REMOVAL_TIME);
        this.writeUserOperationLog(commandContext, historicDecisionInstanceIds.size(), this.builder.getMode(), this.builder.getRemovalTime(), this.builder.isHierarchical(), true);
        BatchEntity batch = this.createBatch(commandContext, new ArrayList<String>(historicDecisionInstanceIds));
        batch.createSeedJobDefinition();
        batch.createMonitorJobDefinition();
        batch.createBatchJobDefinition();
        batch.fireHistoricStartEvent();
        batch.createSeedJob();
        return batch;
    }

    protected List<String> findHistoricInstanceIds(List<String> instanceIds, CommandContext commandContext) {
        List historicDecisionInstances = this.createHistoricDecisionInstanceQuery(commandContext).decisionInstanceIdIn(instanceIds.toArray(new String[0])).list();
        ArrayList<String> ids = new ArrayList<String>();
        for (HistoricDecisionInstance historicDecisionInstance : historicDecisionInstances) {
            ids.add(historicDecisionInstance.getId());
        }
        return ids;
    }

    protected HistoricDecisionInstanceQuery createHistoricDecisionInstanceQuery(CommandContext commandContext) {
        return commandContext.getProcessEngineConfiguration().getHistoryService().createHistoricDecisionInstanceQuery();
    }

    protected void writeUserOperationLog(CommandContext commandContext, int numInstances, SetRemovalTimeToHistoricDecisionInstancesBuilderImpl.Mode mode, Date removalTime, boolean hierarchical, boolean async) {
        ArrayList<PropertyChange> propertyChanges = new ArrayList<PropertyChange>();
        propertyChanges.add(new PropertyChange("mode", null, (Object)mode));
        propertyChanges.add(new PropertyChange("removalTime", null, removalTime));
        propertyChanges.add(new PropertyChange("hierarchical", null, hierarchical));
        propertyChanges.add(new PropertyChange("nrOfInstances", null, numInstances));
        propertyChanges.add(new PropertyChange("async", null, async));
        commandContext.getOperationLogManager().logDecisionInstanceOperation("SetRemovalTime", propertyChanges);
    }

    @Override
    protected BatchConfiguration getAbstractIdsBatchConfiguration(List<String> ids) {
        return new SetRemovalTimeBatchConfiguration(ids).setHierarchical(this.builder.isHierarchical()).setHasRemovalTime(this.hasRemovalTime(this.builder.getMode())).setRemovalTime(this.builder.getRemovalTime());
    }

    protected boolean hasRemovalTime(SetRemovalTimeToHistoricDecisionInstancesBuilderImpl.Mode mode) {
        return this.builder.getMode() == SetRemovalTimeToHistoricDecisionInstancesBuilderImpl.Mode.ABSOLUTE_REMOVAL_TIME || this.builder.getMode() == SetRemovalTimeToHistoricDecisionInstancesBuilderImpl.Mode.CLEARED_REMOVAL_TIME;
    }

    @Override
    protected BatchJobHandler getBatchJobHandler(ProcessEngineConfigurationImpl processEngineConfiguration) {
        return processEngineConfiguration.getBatchHandlers().get("decision-set-removal-time");
    }
}

