/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.deploy.cache;

import java.util.concurrent.Callable;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.AbstractResourceDefinitionManager;
import org.camunda.bpm.engine.impl.persistence.deploy.cache.CacheDeployer;
import org.camunda.bpm.engine.impl.persistence.deploy.cache.CacheFactory;
import org.camunda.bpm.engine.impl.persistence.entity.DeploymentEntity;
import org.camunda.bpm.engine.impl.repository.ResourceDefinitionEntity;
import org.camunda.commons.utils.cache.Cache;

public abstract class ResourceDefinitionCache<T extends ResourceDefinitionEntity> {
    protected Cache<String, T> cache;
    protected CacheDeployer cacheDeployer;

    public ResourceDefinitionCache(CacheFactory factory, int cacheCapacity, CacheDeployer cacheDeployer) {
        this.cache = factory.createCache(cacheCapacity);
        this.cacheDeployer = cacheDeployer;
    }

    public T findDefinitionFromCache(String definitionId) {
        return (T)((ResourceDefinitionEntity)this.cache.get((Object)definitionId));
    }

    public T findDeployedDefinitionById(String definitionId) {
        this.checkInvalidDefinitionId(definitionId);
        ResourceDefinitionEntity definition = (ResourceDefinitionEntity)this.getManager().getCachedResourceDefinitionEntity(definitionId);
        if (definition == null) {
            definition = (ResourceDefinitionEntity)this.getManager().findLatestDefinitionById(definitionId);
        }
        this.checkDefinitionFound(definitionId, definition);
        definition = this.resolveDefinition(definition);
        return (T)definition;
    }

    public T findDeployedLatestDefinitionByKey(String definitionKey) {
        ResourceDefinitionEntity definition = (ResourceDefinitionEntity)this.getManager().findLatestDefinitionByKey(definitionKey);
        this.checkInvalidDefinitionByKey(definitionKey, definition);
        definition = this.resolveDefinition(definition);
        return (T)definition;
    }

    public T findDeployedLatestDefinitionByKeyAndTenantId(String definitionKey, String tenantId) {
        ResourceDefinitionEntity definition = (ResourceDefinitionEntity)this.getManager().findLatestDefinitionByKeyAndTenantId(definitionKey, tenantId);
        this.checkInvalidDefinitionByKeyAndTenantId(definitionKey, tenantId, definition);
        definition = this.resolveDefinition(definition);
        return (T)definition;
    }

    public T findDeployedDefinitionByKeyVersionAndTenantId(final String definitionKey, final Integer definitionVersion, final String tenantId) {
        CommandContext commandContext = Context.getCommandContext();
        ResourceDefinitionEntity definition = (ResourceDefinitionEntity)commandContext.runWithoutAuthorization(new Callable<T>(){

            @Override
            public T call() throws Exception {
                return (ResourceDefinitionEntity)ResourceDefinitionCache.this.getManager().findDefinitionByKeyVersionAndTenantId(definitionKey, definitionVersion, tenantId);
            }
        });
        this.checkInvalidDefinitionByKeyVersionAndTenantId(definitionKey, definitionVersion, tenantId, definition);
        definition = this.resolveDefinition(definition);
        return (T)definition;
    }

    public T findDeployedDefinitionByKeyVersionTagAndTenantId(final String definitionKey, final String definitionVersionTag, final String tenantId) {
        CommandContext commandContext = Context.getCommandContext();
        ResourceDefinitionEntity definition = (ResourceDefinitionEntity)commandContext.runWithoutAuthorization(new Callable<T>(){

            @Override
            public T call() throws Exception {
                return (ResourceDefinitionEntity)ResourceDefinitionCache.this.getManager().findDefinitionByKeyVersionTagAndTenantId(definitionKey, definitionVersionTag, tenantId);
            }
        });
        this.checkInvalidDefinitionByKeyVersionTagAndTenantId(definitionKey, definitionVersionTag, tenantId, definition);
        definition = this.resolveDefinition(definition);
        return (T)definition;
    }

    public T findDeployedDefinitionByDeploymentAndKey(String deploymentId, String definitionKey) {
        ResourceDefinitionEntity definition = (ResourceDefinitionEntity)this.getManager().findDefinitionByDeploymentAndKey(deploymentId, definitionKey);
        this.checkInvalidDefinitionByDeploymentAndKey(deploymentId, definitionKey, definition);
        definition = this.resolveDefinition(definition);
        return (T)definition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T resolveDefinition(T definition) {
        String definitionId = definition.getId();
        String deploymentId = definition.getDeploymentId();
        ResourceDefinitionEntity cachedDefinition = (ResourceDefinitionEntity)this.cache.get((Object)definitionId);
        if (cachedDefinition == null) {
            ResourceDefinitionCache resourceDefinitionCache = this;
            synchronized (resourceDefinitionCache) {
                cachedDefinition = (ResourceDefinitionEntity)this.cache.get((Object)definitionId);
                if (cachedDefinition == null) {
                    DeploymentEntity deployment = Context.getCommandContext().getDeploymentManager().findDeploymentById(deploymentId);
                    deployment.setNew(false);
                    this.cacheDeployer.deployOnlyGivenResourcesOfDeployment(deployment, definition.getResourceName(), definition.getDiagramResourceName());
                    cachedDefinition = (ResourceDefinitionEntity)this.cache.get((Object)definitionId);
                }
            }
            this.checkInvalidDefinitionWasCached(deploymentId, definitionId, cachedDefinition);
        }
        if (cachedDefinition != null) {
            cachedDefinition.updateModifiableFieldsFromEntity(definition);
        }
        return (T)cachedDefinition;
    }

    public void addDefinition(T definition) {
        this.cache.put((Object)definition.getId(), definition);
    }

    public T getDefinition(String id) {
        return (T)((ResourceDefinitionEntity)this.cache.get((Object)id));
    }

    public void removeDefinitionFromCache(String id) {
        this.cache.remove((Object)id);
    }

    public void clear() {
        this.cache.clear();
    }

    public Cache<String, T> getCache() {
        return this.cache;
    }

    protected abstract AbstractResourceDefinitionManager<T> getManager();

    protected abstract void checkInvalidDefinitionId(String var1);

    protected abstract void checkDefinitionFound(String var1, T var2);

    protected abstract void checkInvalidDefinitionByKey(String var1, T var2);

    protected abstract void checkInvalidDefinitionByKeyAndTenantId(String var1, String var2, T var3);

    protected abstract void checkInvalidDefinitionByKeyVersionAndTenantId(String var1, Integer var2, String var3, T var4);

    protected abstract void checkInvalidDefinitionByKeyVersionTagAndTenantId(String var1, String var2, String var3, T var4);

    protected abstract void checkInvalidDefinitionByDeploymentAndKey(String var1, String var2, T var3);

    protected abstract void checkInvalidDefinitionWasCached(String var1, String var2, T var3);
}

