/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity;

import camundajar.impl.com.google.gson.JsonObject;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.filter.Filter;
import org.camunda.bpm.engine.impl.AbstractQuery;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.QueryValidators;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.db.DbEntityLifecycleAware;
import org.camunda.bpm.engine.impl.db.EnginePersistenceLogger;
import org.camunda.bpm.engine.impl.db.HasDbReferences;
import org.camunda.bpm.engine.impl.db.HasDbRevision;
import org.camunda.bpm.engine.impl.json.JsonObjectConverter;
import org.camunda.bpm.engine.impl.json.JsonTaskQueryConverter;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.impl.util.JsonUtil;
import org.camunda.bpm.engine.query.Query;

public class FilterEntity
implements Filter,
Serializable,
DbEntity,
HasDbRevision,
HasDbReferences,
DbEntityLifecycleAware {
    private static final long serialVersionUID = 1L;
    protected static final EnginePersistenceLogger LOG = ProcessEngineLogger.PERSISTENCE_LOGGER;
    public static final Map<String, JsonObjectConverter<?>> queryConverter = new HashMap();
    protected String id;
    protected String resourceType;
    protected String name;
    protected String owner;
    protected AbstractQuery query;
    protected Map<String, Object> properties;
    protected int revision = 0;

    protected FilterEntity() {
    }

    public FilterEntity(String resourceType) {
        this.setResourceType(resourceType);
        this.setQueryInternal("{}");
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public Filter setResourceType(String resourceType) {
        EnsureUtil.ensureNotEmpty(NotValidException.class, "Filter resource type must not be null or empty", "resourceType", resourceType);
        EnsureUtil.ensureNull(NotValidException.class, "Cannot overwrite filter resource type", "resourceType", this.resourceType);
        this.resourceType = resourceType;
        return this;
    }

    @Override
    public String getResourceType() {
        return this.resourceType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Filter setName(String name) {
        EnsureUtil.ensureNotEmpty(NotValidException.class, "Filter name must not be null or empty", "name", name);
        this.name = name;
        return this;
    }

    @Override
    public String getOwner() {
        return this.owner;
    }

    @Override
    public Filter setOwner(String owner) {
        this.owner = owner;
        return this;
    }

    @Override
    public <T extends Query<?, ?>> T getQuery() {
        return (T)this.query;
    }

    public String getQueryInternal() {
        JsonObjectConverter<AbstractQuery> converter = this.getConverter();
        return converter.toJson(this.query);
    }

    @Override
    public <T extends Query<?, ?>> Filter setQuery(T query) {
        EnsureUtil.ensureNotNull(NotValidException.class, "query", query);
        this.query = (AbstractQuery)query;
        return this;
    }

    public void setQueryInternal(String query) {
        EnsureUtil.ensureNotNull(NotValidException.class, "query", (Object)query);
        JsonObjectConverter converter = this.getConverter();
        this.query = (AbstractQuery)converter.toObject(JsonUtil.asObject(query));
    }

    @Override
    public Map<String, Object> getProperties() {
        if (this.properties != null) {
            JsonObject json = JsonUtil.asObject(this.properties);
            return JsonUtil.asMap(json);
        }
        return null;
    }

    public String getPropertiesInternal() {
        return JsonUtil.asString(this.properties);
    }

    @Override
    public Filter setProperties(Map<String, Object> properties) {
        this.properties = properties;
        return this;
    }

    public void setPropertiesInternal(String properties) {
        if (properties != null) {
            JsonObject json = JsonUtil.asObject(properties);
            this.properties = JsonUtil.asMap(json);
        } else {
            this.properties = null;
        }
    }

    @Override
    public int getRevision() {
        return this.revision;
    }

    @Override
    public void setRevision(int revision) {
        this.revision = revision;
    }

    @Override
    public int getRevisionNext() {
        return this.revision + 1;
    }

    @Override
    public <T extends Query<?, ?>> Filter extend(T extendingQuery) {
        EnsureUtil.ensureNotNull(NotValidException.class, "extendingQuery", extendingQuery);
        if (!extendingQuery.getClass().equals(this.query.getClass())) {
            throw LOG.queryExtensionException(this.query.getClass().getName(), extendingQuery.getClass().getName());
        }
        FilterEntity copy = this.copyFilter();
        copy.setQuery(this.query.extend(extendingQuery));
        return copy;
    }

    protected <T> JsonObjectConverter<T> getConverter() {
        JsonObjectConverter<?> converter = queryConverter.get(this.resourceType);
        if (converter != null) {
            return converter;
        }
        throw LOG.unsupportedResourceTypeException(this.resourceType);
    }

    @Override
    public Object getPersistentState() {
        HashMap<String, Object> persistentState = new HashMap<String, Object>();
        persistentState.put("name", this.name);
        persistentState.put("owner", this.owner);
        persistentState.put("query", this.query);
        persistentState.put("properties", this.properties);
        return persistentState;
    }

    protected FilterEntity copyFilter() {
        FilterEntity copy = new FilterEntity(this.getResourceType());
        copy.setName(this.getName());
        copy.setOwner(this.getOwner());
        copy.setQueryInternal(this.getQueryInternal());
        copy.setPropertiesInternal(this.getPropertiesInternal());
        return copy;
    }

    @Override
    public void postLoad() {
        if (this.query != null) {
            this.query.addValidator(QueryValidators.StoredQueryValidator.get());
        }
    }

    @Override
    public Set<String> getReferencedEntityIds() {
        HashSet<String> referencedEntityIds = new HashSet<String>();
        return referencedEntityIds;
    }

    @Override
    public Map<String, Class> getReferencedEntitiesIdAndClass() {
        HashMap<String, Class> referenceIdAndClass = new HashMap<String, Class>();
        return referenceIdAndClass;
    }

    static {
        queryConverter.put("Task", new JsonTaskQueryConverter());
    }
}

