/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.jobexecutor;

import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.jobexecutor.FailedJobCommandFactory;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutorLogger;
import org.camunda.bpm.engine.impl.jobexecutor.JobFailureCollector;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;

public class FailedJobListener
implements Command<Void> {
    protected CommandExecutor commandExecutor;
    protected JobFailureCollector jobFailureCollector;
    private static final JobExecutorLogger LOG = ProcessEngineLogger.JOB_EXECUTOR_LOGGER;
    private int countRetries = 0;
    private int totalRetries = 3;

    public FailedJobListener(CommandExecutor commandExecutor, JobFailureCollector jobFailureCollector) {
        this.commandExecutor = commandExecutor;
        this.jobFailureCollector = jobFailureCollector;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        this.initTotalRetries(commandContext);
        this.logJobFailure(commandContext);
        FailedJobCommandFactory failedJobCommandFactory = commandContext.getFailedJobCommandFactory();
        final String jobId = this.jobFailureCollector.getJobId();
        final Command<Object> cmd = failedJobCommandFactory.getCommand(jobId, this.jobFailureCollector.getFailure());
        this.commandExecutor.execute(new Command<Void>(){

            @Override
            public Void execute(CommandContext commandContext) {
                JobEntity job = commandContext.getJobManager().findJobById(jobId);
                if (job != null) {
                    job.setFailedActivityId(FailedJobListener.this.jobFailureCollector.getFailedActivityId());
                    FailedJobListener.this.fireHistoricJobFailedEvt(job);
                    cmd.execute(commandContext);
                } else {
                    LOG.debugFailedJobNotFound(jobId);
                }
                return null;
            }
        });
        return null;
    }

    private void initTotalRetries(CommandContext commandContext) {
        this.totalRetries = commandContext.getProcessEngineConfiguration().getFailedJobListenerMaxRetries();
    }

    protected void fireHistoricJobFailedEvt(JobEntity job) {
        CommandContext commandContext = Context.getCommandContext();
        job.incrementSequenceCounter();
        commandContext.getHistoricJobLogManager().fireJobFailedEvent(job, this.jobFailureCollector.getFailure());
    }

    protected void logJobFailure(CommandContext commandContext) {
        if (commandContext.getProcessEngineConfiguration().isMetricsEnabled()) {
            commandContext.getProcessEngineConfiguration().getMetricsRegistry().markOccurrence("job-failed");
        }
    }

    public void incrementCountRetries() {
        ++this.countRetries;
    }

    public int getRetriesLeft() {
        return Math.max(0, this.totalRetries - this.countRetries);
    }
}

