/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd.optimize;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.camunda.bpm.engine.history.HistoricVariableUpdate;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.cmd.CommandLogger;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricDetailVariableInstanceUpdateEntity;
import org.camunda.bpm.engine.impl.variable.serializer.AbstractTypedValueSerializer;

public class OptimizeHistoricVariableUpdateQueryCmd
implements Command<List<HistoricVariableUpdate>> {
    private static final CommandLogger LOG = ProcessEngineLogger.CMD_LOGGER;
    protected Date occurredAfter;
    protected Date occurredAt;
    protected int maxResults;

    public OptimizeHistoricVariableUpdateQueryCmd(Date occurredAfter, Date occurredAt, int maxResults) {
        this.occurredAfter = occurredAfter;
        this.occurredAt = occurredAt;
        this.maxResults = maxResults;
    }

    @Override
    public List<HistoricVariableUpdate> execute(CommandContext commandContext) {
        List<HistoricVariableUpdate> historicVariableUpdates = commandContext.getOptimizeManager().getHistoricVariableUpdates(this.occurredAfter, this.occurredAt, this.maxResults);
        this.fetchVariableValues(historicVariableUpdates, commandContext);
        return historicVariableUpdates;
    }

    private void fetchVariableValues(List<HistoricVariableUpdate> historicVariableUpdates, CommandContext commandContext) {
        if (historicVariableUpdates != null) {
            List<String> byteArrayIds = this.getByteArrayIds(historicVariableUpdates);
            if (!byteArrayIds.isEmpty()) {
                commandContext.getOptimizeManager().fetchHistoricVariableUpdateByteArrays(byteArrayIds);
            }
            this.resolveTypedValues(historicVariableUpdates);
        }
    }

    protected boolean isNotByteArrayVariableType(HistoricDetailVariableInstanceUpdateEntity entity) {
        return !AbstractTypedValueSerializer.BINARY_VALUE_TYPES.contains(entity.getSerializer().getType().getName());
    }

    protected boolean isHistoricDetailVariableInstanceUpdateEntity(HistoricVariableUpdate variableUpdate) {
        return variableUpdate instanceof HistoricDetailVariableInstanceUpdateEntity;
    }

    protected List<String> getByteArrayIds(List<HistoricVariableUpdate> variableUpdates) {
        ArrayList<String> byteArrayIds = new ArrayList<String>();
        for (HistoricVariableUpdate variableUpdate : variableUpdates) {
            String byteArrayId;
            HistoricDetailVariableInstanceUpdateEntity entity;
            if (!this.isHistoricDetailVariableInstanceUpdateEntity(variableUpdate) || !this.isNotByteArrayVariableType(entity = (HistoricDetailVariableInstanceUpdateEntity)variableUpdate) || (byteArrayId = entity.getByteArrayValueId()) == null) continue;
            byteArrayIds.add(byteArrayId);
        }
        return byteArrayIds;
    }

    protected void resolveTypedValues(List<HistoricVariableUpdate> variableUpdates) {
        for (HistoricVariableUpdate variableUpdate : variableUpdates) {
            HistoricDetailVariableInstanceUpdateEntity entity;
            if (!this.isHistoricDetailVariableInstanceUpdateEntity(variableUpdate) || !this.isNotByteArrayVariableType(entity = (HistoricDetailVariableInstanceUpdateEntity)variableUpdate)) continue;
            try {
                entity.getTypedValue(false);
            }
            catch (Exception t) {
                LOG.exceptionWhileGettingValueForVariable(t);
            }
        }
    }
}

