/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.jobexecutor.historycleanup;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.jobexecutor.historycleanup.HistoryCleanupHandler;
import org.camunda.bpm.engine.impl.jobexecutor.historycleanup.HistoryCleanupHelper;

public class HistoryCleanupBatch
extends HistoryCleanupHandler {
    private List<String> historicProcessInstanceIds = Collections.emptyList();
    private List<String> historicDecisionInstanceIds = Collections.emptyList();
    private List<String> historicCaseInstanceIds = Collections.emptyList();
    private List<String> historicBatchIds = Collections.emptyList();

    public List<String> getHistoricProcessInstanceIds() {
        return this.historicProcessInstanceIds;
    }

    public void setHistoricProcessInstanceIds(List<String> historicProcessInstanceIds) {
        this.historicProcessInstanceIds = historicProcessInstanceIds;
    }

    public List<String> getHistoricDecisionInstanceIds() {
        return this.historicDecisionInstanceIds;
    }

    public void setHistoricDecisionInstanceIds(List<String> historicDecisionInstanceIds) {
        this.historicDecisionInstanceIds = historicDecisionInstanceIds;
    }

    public List<String> getHistoricCaseInstanceIds() {
        return this.historicCaseInstanceIds;
    }

    public void setHistoricCaseInstanceIds(List<String> historicCaseInstanceIds) {
        this.historicCaseInstanceIds = historicCaseInstanceIds;
    }

    public List<String> getHistoricBatchIds() {
        return this.historicBatchIds;
    }

    public void setHistoricBatchIds(List<String> historicBatchIds) {
        this.historicBatchIds = historicBatchIds;
    }

    public int size() {
        return this.historicProcessInstanceIds.size() + this.historicDecisionInstanceIds.size() + this.historicCaseInstanceIds.size() + this.historicBatchIds.size();
    }

    @Override
    public void performCleanup() {
        CommandContext commandContext = Context.getCommandContext();
        HistoryCleanupHelper.prepareNextBatch(this, commandContext);
        if (this.size() > 0) {
            if (this.historicProcessInstanceIds.size() > 0) {
                commandContext.getHistoricProcessInstanceManager().deleteHistoricProcessInstanceByIds(this.historicProcessInstanceIds);
            }
            if (this.historicDecisionInstanceIds.size() > 0) {
                commandContext.getHistoricDecisionInstanceManager().deleteHistoricDecisionInstanceByIds(this.historicDecisionInstanceIds);
            }
            if (this.historicCaseInstanceIds.size() > 0) {
                commandContext.getHistoricCaseInstanceManager().deleteHistoricCaseInstancesByIds(this.historicCaseInstanceIds);
            }
            if (this.historicBatchIds.size() > 0) {
                commandContext.getHistoricBatchManager().deleteHistoricBatchesByIds(this.historicBatchIds);
            }
        }
    }

    @Override
    protected Map<String, Long> reportMetrics() {
        HashMap<String, Long> reports = new HashMap<String, Long>();
        if (this.historicProcessInstanceIds.size() > 0) {
            reports.put("history-cleanup-removed-process-instances", Long.valueOf(this.historicProcessInstanceIds.size()));
        }
        if (this.historicDecisionInstanceIds.size() > 0) {
            reports.put("history-cleanup-removed-decision-instances", Long.valueOf(this.historicDecisionInstanceIds.size()));
        }
        if (this.historicCaseInstanceIds.size() > 0) {
            reports.put("history-cleanup-removed-case-instances", Long.valueOf(this.historicCaseInstanceIds.size()));
        }
        if (this.historicBatchIds.size() > 0) {
            reports.put("history-cleanup-removed-batch-operations", Long.valueOf(this.historicBatchIds.size()));
        }
        return reports;
    }

    @Override
    boolean shouldRescheduleNow() {
        return this.size() >= this.getBatchSizeThreshold();
    }

    public Integer getBatchSizeThreshold() {
        return Context.getProcessEngineConfiguration().getHistoryCleanupBatchThreshold();
    }
}

