/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.variable.serializer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.variable.serializer.TypedValueSerializer;
import org.camunda.bpm.engine.impl.variable.serializer.VariableSerializerFactory;
import org.camunda.bpm.engine.impl.variable.serializer.VariableSerializers;
import org.camunda.bpm.engine.variable.type.ValueType;
import org.camunda.bpm.engine.variable.value.TypedValue;

public class DefaultVariableSerializers
implements Serializable,
VariableSerializers {
    private static final long serialVersionUID = 1L;
    protected List<TypedValueSerializer<?>> serializerList = new ArrayList();
    protected Map<String, TypedValueSerializer<?>> serializerMap = new HashMap();

    public DefaultVariableSerializers() {
    }

    public DefaultVariableSerializers(DefaultVariableSerializers serializers) {
        this.serializerList.addAll(serializers.serializerList);
        this.serializerMap.putAll(serializers.serializerMap);
    }

    @Override
    public TypedValueSerializer<?> getSerializerByName(String serializerName) {
        return this.serializerMap.get(serializerName);
    }

    @Override
    public TypedValueSerializer<?> findSerializerForValue(TypedValue value, VariableSerializerFactory fallBackSerializerFactory) {
        String defaultSerializationFormat = Context.getProcessEngineConfiguration().getDefaultSerializationFormat();
        ArrayList matchedSerializers = new ArrayList();
        ValueType type = value.getType();
        if (type != null && type.isAbstract()) {
            throw new ProcessEngineException("Cannot serialize value of abstract type " + type.getName());
        }
        for (TypedValueSerializer<?> typedValueSerializer : this.serializerList) {
            if (type != null && !typedValueSerializer.getType().equals(type) || !typedValueSerializer.canHandle(value)) continue;
            matchedSerializers.add(typedValueSerializer);
            if (!typedValueSerializer.getType().isPrimitiveValueType()) continue;
            break;
        }
        if (matchedSerializers.size() == 0) {
            TypedValueSerializer<?> serializer;
            if (fallBackSerializerFactory != null && (serializer = fallBackSerializerFactory.getSerializer(value)) != null) {
                return serializer;
            }
            throw new ProcessEngineException("Cannot find serializer for value '" + value + "'.");
        }
        if (matchedSerializers.size() == 1) {
            return (TypedValueSerializer)matchedSerializers.get(0);
        }
        if (defaultSerializationFormat != null) {
            for (TypedValueSerializer<Object> typedValueSerializer : matchedSerializers) {
                if (!defaultSerializationFormat.equals(typedValueSerializer.getSerializationDataformat())) continue;
                return typedValueSerializer;
            }
        }
        return (TypedValueSerializer)matchedSerializers.get(0);
    }

    @Override
    public TypedValueSerializer<?> findSerializerForValue(TypedValue value) {
        return this.findSerializerForValue(value, null);
    }

    @Override
    public DefaultVariableSerializers addSerializer(TypedValueSerializer<?> serializer) {
        return this.addSerializer((TypedValueSerializer)serializer, this.serializerList.size());
    }

    @Override
    public DefaultVariableSerializers addSerializer(TypedValueSerializer<?> serializer, int index) {
        this.serializerList.add(index, serializer);
        this.serializerMap.put(serializer.getName(), serializer);
        return this;
    }

    public void setSerializerList(List<TypedValueSerializer<?>> serializerList) {
        this.serializerList.clear();
        this.serializerList.addAll(serializerList);
        this.serializerMap.clear();
        for (TypedValueSerializer<?> serializer : serializerList) {
            this.serializerMap.put(serializer.getName(), serializer);
        }
    }

    @Override
    public int getSerializerIndex(TypedValueSerializer<?> serializer) {
        return this.serializerList.indexOf(serializer);
    }

    @Override
    public int getSerializerIndexByName(String serializerName) {
        TypedValueSerializer<?> serializer = this.serializerMap.get(serializerName);
        if (serializer != null) {
            return this.getSerializerIndex(serializer);
        }
        return -1;
    }

    @Override
    public VariableSerializers removeSerializer(TypedValueSerializer<?> serializer) {
        this.serializerList.remove(serializer);
        this.serializerMap.remove(serializer.getName());
        return this;
    }

    @Override
    public VariableSerializers join(VariableSerializers other) {
        DefaultVariableSerializers copy = new DefaultVariableSerializers();
        for (TypedValueSerializer<?> thisSerializer : this.serializerList) {
            TypedValueSerializer<?> serializer = other.getSerializerByName(thisSerializer.getName());
            if (serializer == null) {
                serializer = thisSerializer;
            }
            copy.addSerializer((TypedValueSerializer)serializer);
        }
        for (TypedValueSerializer<?> otherSerializer : other.getSerializers()) {
            if (copy.serializerMap.containsKey(otherSerializer.getName())) continue;
            copy.addSerializer((TypedValueSerializer)otherSerializer);
        }
        return copy;
    }

    @Override
    public List<TypedValueSerializer<?>> getSerializers() {
        return new ArrayList(this.serializerList);
    }
}

