/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.jobexecutor.historycleanup;

import camundajar.impl.com.google.gson.JsonObject;
import org.camunda.bpm.engine.impl.cfg.TransactionState;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.jobexecutor.JobHandler;
import org.camunda.bpm.engine.impl.jobexecutor.historycleanup.HistoryCleanupBatch;
import org.camunda.bpm.engine.impl.jobexecutor.historycleanup.HistoryCleanupHandler;
import org.camunda.bpm.engine.impl.jobexecutor.historycleanup.HistoryCleanupHelper;
import org.camunda.bpm.engine.impl.jobexecutor.historycleanup.HistoryCleanupJobHandlerConfiguration;
import org.camunda.bpm.engine.impl.jobexecutor.historycleanup.HistoryCleanupRemovalTime;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.impl.util.JsonUtil;

public class HistoryCleanupJobHandler
implements JobHandler<HistoryCleanupJobHandlerConfiguration> {
    public static final String TYPE = "history-cleanup";

    @Override
    public void execute(HistoryCleanupJobHandlerConfiguration configuration, ExecutionEntity execution, CommandContext commandContext, String tenantId) {
        HistoryCleanupHandler cleanupHandler = this.initCleanupHandler(configuration, commandContext);
        if (configuration.isImmediatelyDue() || this.isWithinBatchWindow(commandContext)) {
            cleanupHandler.performCleanup();
        }
        commandContext.getTransactionContext().addTransactionListener(TransactionState.COMMITTED, cleanupHandler);
    }

    protected HistoryCleanupHandler initCleanupHandler(HistoryCleanupJobHandlerConfiguration configuration, CommandContext commandContext) {
        HistoryCleanupHandler cleanupHandler = null;
        cleanupHandler = this.isHistoryCleanupStrategyRemovalTimeBased(commandContext) ? new HistoryCleanupRemovalTime() : new HistoryCleanupBatch();
        CommandExecutor commandExecutor = commandContext.getProcessEngineConfiguration().getCommandExecutorTxRequiresNew();
        String jobId = commandContext.getCurrentJob().getId();
        return cleanupHandler.setConfiguration(configuration).setCommandExecutor(commandExecutor).setJobId(jobId);
    }

    protected boolean isHistoryCleanupStrategyRemovalTimeBased(CommandContext commandContext) {
        String historyRemovalTimeStrategy = commandContext.getProcessEngineConfiguration().getHistoryCleanupStrategy();
        return "removalTimeBased".equals(historyRemovalTimeStrategy);
    }

    protected boolean isWithinBatchWindow(CommandContext commandContext) {
        return HistoryCleanupHelper.isWithinBatchWindow(ClockUtil.getCurrentTime(), commandContext.getProcessEngineConfiguration());
    }

    @Override
    public HistoryCleanupJobHandlerConfiguration newConfiguration(String canonicalString) {
        JsonObject jsonObject = JsonUtil.asObject(canonicalString);
        return HistoryCleanupJobHandlerConfiguration.fromJson(jsonObject);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void onDelete(HistoryCleanupJobHandlerConfiguration configuration, JobEntity jobEntity) {
    }
}

