/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.deploy.cache;

import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.persistence.AbstractResourceDefinitionManager;
import org.camunda.bpm.engine.impl.persistence.deploy.cache.CacheDeployer;
import org.camunda.bpm.engine.impl.persistence.deploy.cache.CacheFactory;
import org.camunda.bpm.engine.impl.persistence.deploy.cache.ResourceDefinitionCache;
import org.camunda.bpm.engine.impl.persistence.entity.CamundaFormDefinitionEntity;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class CamundaFormDefinitionCache
extends ResourceDefinitionCache<CamundaFormDefinitionEntity> {
    public CamundaFormDefinitionCache(CacheFactory factory, int cacheCapacity, CacheDeployer cacheDeployer) {
        super(factory, cacheCapacity, cacheDeployer);
    }

    @Override
    protected AbstractResourceDefinitionManager<CamundaFormDefinitionEntity> getManager() {
        return Context.getCommandContext().getCamundaFormDefinitionManager();
    }

    @Override
    protected void checkInvalidDefinitionId(String definitionId) {
        EnsureUtil.ensureNotNull("Invalid camunda form definition id", "camundaFormDefinitionId", (Object)definitionId);
    }

    @Override
    protected void checkDefinitionFound(String definitionId, CamundaFormDefinitionEntity definition) {
        EnsureUtil.ensureNotNull("no deployed camunda form definition found with id '" + definitionId + "'", "camundaFormDefinition", (Object)definition);
    }

    @Override
    protected void checkInvalidDefinitionByKey(String definitionKey, CamundaFormDefinitionEntity definition) {
        EnsureUtil.ensureNotNull("no deployed camunda form definition found with key '" + definitionKey + "'", "camundaFormDefinition", (Object)definition);
    }

    @Override
    protected void checkInvalidDefinitionByKeyAndTenantId(String definitionKey, String tenantId, CamundaFormDefinitionEntity definition) {
        EnsureUtil.ensureNotNull("no deployed camunda form definition found with key '" + definitionKey + "' and tenant-id '" + tenantId + "'", "camundaFormDefinition", (Object)definition);
    }

    @Override
    protected void checkInvalidDefinitionByKeyVersionAndTenantId(String definitionKey, Integer definitionVersion, String tenantId, CamundaFormDefinitionEntity definition) {
        EnsureUtil.ensureNotNull("no deployed camunda form definition found with key '" + definitionKey + "', version '" + definitionVersion + "' and tenant-id '" + tenantId + "'", "camundaFormDefinition", (Object)definition);
    }

    @Override
    protected void checkInvalidDefinitionByKeyVersionTagAndTenantId(String definitionKey, String definitionVersionTag, String tenantId, CamundaFormDefinitionEntity definition) {
    }

    @Override
    protected void checkInvalidDefinitionByDeploymentAndKey(String deploymentId, String definitionKey, CamundaFormDefinitionEntity definition) {
        EnsureUtil.ensureNotNull("no deployed camunda form definition found with key '" + definitionKey + "' in deployment '" + deploymentId + "'", "camundaFormDefinition", (Object)definition);
    }

    @Override
    protected void checkInvalidDefinitionWasCached(String deploymentId, String definitionId, CamundaFormDefinitionEntity definition) {
        EnsureUtil.ensureNotNull("deployment '" + deploymentId + "' didn't put camunda form definition '" + definitionId + "' in the cache", "cachedProcessDefinition", (Object)definition);
    }
}

