/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.test;

import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.history.UserOperationLogEntry;
import org.camunda.bpm.engine.impl.HistoryLevelSetupCommand;
import org.camunda.bpm.engine.impl.ManagementServiceImpl;
import org.camunda.bpm.engine.impl.ProcessEngineImpl;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.application.ProcessApplicationManager;
import org.camunda.bpm.engine.impl.bpmn.deployer.BpmnDeployer;
import org.camunda.bpm.engine.impl.cfg.IdGenerator;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cmmn.behavior.CaseControlRuleImpl;
import org.camunda.bpm.engine.impl.cmmn.deployer.CmmnDeployer;
import org.camunda.bpm.engine.impl.db.DbIdGenerator;
import org.camunda.bpm.engine.impl.db.PersistenceSession;
import org.camunda.bpm.engine.impl.db.entitymanager.DbEntityManager;
import org.camunda.bpm.engine.impl.dmn.deployer.DecisionDefinitionDeployer;
import org.camunda.bpm.engine.impl.el.FixedValue;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutor;
import org.camunda.bpm.engine.impl.management.DatabasePurgeReport;
import org.camunda.bpm.engine.impl.management.PurgeReport;
import org.camunda.bpm.engine.impl.persistence.deploy.cache.CachePurgeReport;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyEntity;
import org.camunda.bpm.engine.impl.test.ProcessEngineAssert;
import org.camunda.bpm.engine.impl.test.RequiredDatabase;
import org.camunda.bpm.engine.impl.util.ClassNameUtil;
import org.camunda.bpm.engine.impl.util.ReflectUtil;
import org.camunda.bpm.engine.repository.DeploymentBuilder;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.junit.Assert;
import org.slf4j.Logger;

public abstract class TestHelper {
    private static Logger LOG = ProcessEngineLogger.TEST_LOGGER.getLogger();
    public static final String EMPTY_LINE = "                                                                                           ";
    public static final List<String> TABLENAMES_EXCLUDED_FROM_DB_CLEAN_CHECK = Arrays.asList("ACT_GE_PROPERTY", "ACT_GE_SCHEMA_LOG");
    static Map<String, ProcessEngine> processEngines = new HashMap<String, ProcessEngine>();
    public static final List<String> RESOURCE_SUFFIXES = new ArrayList<String>();

    @Deprecated
    public static void assertProcessEnded(ProcessEngine processEngine, String processInstanceId) {
        ProcessEngineAssert.assertProcessEnded(processEngine, processInstanceId);
    }

    public static String annotationDeploymentSetUp(ProcessEngine processEngine, Class<?> testClass, String methodName, Deployment deploymentAnnotation) {
        boolean onMethod;
        Method method;
        block6: {
            method = null;
            onMethod = true;
            try {
                method = TestHelper.getMethod(testClass, methodName);
            }
            catch (Exception e) {
                if (deploymentAnnotation != null) break block6;
                return null;
            }
        }
        if (deploymentAnnotation == null) {
            deploymentAnnotation = method.getAnnotation(Deployment.class);
        }
        if (deploymentAnnotation == null) {
            onMethod = false;
            for (Class<?> lookForAnnotationClass = testClass; lookForAnnotationClass != Object.class; lookForAnnotationClass = lookForAnnotationClass.getSuperclass()) {
                deploymentAnnotation = lookForAnnotationClass.getAnnotation(Deployment.class);
                if (deploymentAnnotation == null) continue;
                testClass = lookForAnnotationClass;
                break;
            }
        }
        if (deploymentAnnotation != null) {
            String[] resources = deploymentAnnotation.resources();
            LOG.debug("annotation @Deployment creates deployment for {}.{}", (Object)ClassNameUtil.getClassNameWithoutPackage(testClass), (Object)methodName);
            return TestHelper.annotationDeploymentSetUp(processEngine, resources, testClass, onMethod, methodName);
        }
        return null;
    }

    public static String annotationDeploymentSetUp(ProcessEngine processEngine, String[] resources, Class<?> testClass, String methodName) {
        return TestHelper.annotationDeploymentSetUp(processEngine, resources, testClass, true, methodName);
    }

    public static String annotationDeploymentSetUp(ProcessEngine processEngine, String[] resources, Class<?> testClass, boolean onMethod, String methodName) {
        if (resources != null) {
            if (resources.length == 0 && methodName != null) {
                String name = onMethod ? methodName : null;
                String resource = TestHelper.getBpmnProcessDefinitionResource(testClass, name);
                resources = new String[]{resource};
            }
            DeploymentBuilder deploymentBuilder = processEngine.getRepositoryService().createDeployment().name(ClassNameUtil.getClassNameWithoutPackage(testClass) + "." + methodName);
            for (String resource : resources) {
                deploymentBuilder.addClasspathResource(resource);
            }
            return deploymentBuilder.deploy().getId();
        }
        return null;
    }

    public static String annotationDeploymentSetUp(ProcessEngine processEngine, Class<?> testClass, String methodName) {
        return TestHelper.annotationDeploymentSetUp(processEngine, testClass, methodName, (Deployment)null);
    }

    public static void annotationDeploymentTearDown(ProcessEngine processEngine, String deploymentId, Class<?> testClass, String methodName) {
        LOG.debug("annotation @Deployment deletes deployment for {}.{}", (Object)ClassNameUtil.getClassNameWithoutPackage(testClass), (Object)methodName);
        TestHelper.deleteDeployment(processEngine, deploymentId);
    }

    public static void deleteDeployment(ProcessEngine processEngine, String deploymentId) {
        if (deploymentId != null) {
            processEngine.getRepositoryService().deleteDeployment(deploymentId, true, true, true);
        }
    }

    public static String getBpmnProcessDefinitionResource(Class<?> type, String name) {
        for (String suffix : RESOURCE_SUFFIXES) {
            String resource = TestHelper.createResourceName(type, name, suffix);
            InputStream inputStream = ReflectUtil.getResourceAsStream(resource);
            if (inputStream == null) continue;
            return resource;
        }
        return TestHelper.createResourceName(type, name, BpmnDeployer.BPMN_RESOURCE_SUFFIXES[0]);
    }

    private static String createResourceName(Class<?> type, String name, String suffix) {
        StringBuilder r = new StringBuilder(type.getName().replace('.', '/'));
        if (name != null) {
            r.append("." + name);
        }
        return r.append("." + suffix).toString();
    }

    public static boolean annotationRequiredHistoryLevelCheck(ProcessEngine processEngine, RequiredHistoryLevel annotation, Class<?> testClass, String methodName) {
        if (annotation != null) {
            return TestHelper.historyLevelCheck(processEngine, annotation);
        }
        return TestHelper.annotationRequiredHistoryLevelCheck(processEngine, testClass, methodName);
    }

    private static boolean historyLevelCheck(ProcessEngine processEngine, RequiredHistoryLevel annotation) {
        ProcessEngineConfigurationImpl processEngineConfiguration = (ProcessEngineConfigurationImpl)processEngine.getProcessEngineConfiguration();
        HistoryLevel requiredHistoryLevel = TestHelper.getHistoryLevelForName(processEngineConfiguration.getHistoryLevels(), annotation.value());
        HistoryLevel currentHistoryLevel = processEngineConfiguration.getHistoryLevel();
        return currentHistoryLevel.getId() >= requiredHistoryLevel.getId();
    }

    private static HistoryLevel getHistoryLevelForName(List<HistoryLevel> historyLevels, String name) {
        for (HistoryLevel historyLevel : historyLevels) {
            if (!historyLevel.getName().equalsIgnoreCase(name)) continue;
            return historyLevel;
        }
        throw new IllegalArgumentException("Unknown history level: " + name);
    }

    public static boolean annotationRequiredHistoryLevelCheck(ProcessEngine processEngine, Class<?> testClass, String methodName) {
        RequiredHistoryLevel annotation = TestHelper.getAnnotation(processEngine, testClass, methodName, RequiredHistoryLevel.class);
        if (annotation != null) {
            return TestHelper.historyLevelCheck(processEngine, annotation);
        }
        return true;
    }

    public static boolean annotationRequiredDatabaseCheck(ProcessEngine processEngine, RequiredDatabase annotation, Class<?> testClass, String methodName) {
        if (annotation != null) {
            return TestHelper.databaseCheck(processEngine, annotation);
        }
        return TestHelper.annotationRequiredDatabaseCheck(processEngine, testClass, methodName);
    }

    public static boolean annotationRequiredDatabaseCheck(ProcessEngine processEngine, Class<?> testClass, String methodName) {
        RequiredDatabase annotation = TestHelper.getAnnotation(processEngine, testClass, methodName, RequiredDatabase.class);
        if (annotation != null) {
            return TestHelper.databaseCheck(processEngine, annotation);
        }
        return true;
    }

    private static boolean databaseCheck(ProcessEngine processEngine, RequiredDatabase annotation) {
        String[] includes;
        ProcessEngineConfigurationImpl processEngineConfiguration = (ProcessEngineConfigurationImpl)processEngine.getProcessEngineConfiguration();
        String actualDbType = processEngineConfiguration.getDbSqlSessionFactory().getDatabaseType();
        String[] excludes = annotation.excludes();
        if (excludes != null) {
            for (String exclude : excludes) {
                if (!exclude.equals(actualDbType)) continue;
                return false;
            }
        }
        if ((includes = annotation.includes()) != null && includes.length > 0) {
            for (String include : includes) {
                if (!include.equals(actualDbType)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private static <T extends Annotation> T getAnnotation(ProcessEngine processEngine, Class<?> testClass, String methodName, Class<T> annotationClass) {
        Method method = null;
        T annotation = null;
        try {
            method = TestHelper.getMethod(testClass, methodName);
            annotation = method.getAnnotation(annotationClass);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (annotation == null) {
            annotation = testClass.getAnnotation(annotationClass);
        }
        return annotation;
    }

    protected static Method getMethod(Class<?> clazz, String methodName) throws SecurityException, NoSuchMethodException {
        return clazz.getMethod(methodName, null);
    }

    public static void assertAndEnsureCleanDbAndCache(ProcessEngine processEngine) {
        TestHelper.assertAndEnsureCleanDbAndCache(processEngine, true);
    }

    public static String assertAndEnsureCleanDbAndCache(ProcessEngine processEngine, boolean fail) {
        ProcessEngineConfigurationImpl processEngineConfiguration = ((ProcessEngineImpl)processEngine).getProcessEngineConfiguration();
        TestHelper.clearUserOperationLog(processEngineConfiguration);
        LOG.debug("verifying that db is clean after test");
        PurgeReport purgeReport = ((ManagementServiceImpl)processEngine.getManagementService()).purge();
        String paRegistrationMessage = TestHelper.assertAndEnsureNoProcessApplicationsRegistered(processEngine);
        StringBuilder message = new StringBuilder();
        CachePurgeReport cachePurgeReport = purgeReport.getCachePurgeReport();
        if (!cachePurgeReport.isEmpty()) {
            message.append("Deployment cache is not clean:\n").append(cachePurgeReport.getPurgeReportAsString());
        } else {
            LOG.debug("Deployment cache was clean.");
        }
        DatabasePurgeReport databasePurgeReport = purgeReport.getDatabasePurgeReport();
        if (!databasePurgeReport.isEmpty()) {
            message.append("Database is not clean:\n").append(databasePurgeReport.getPurgeReportAsString());
        } else {
            LOG.debug(purgeReport.getDatabasePurgeReport().isDbContainsLicenseKey() ? "Database contains license key but is considered clean." : "Database was clean.");
        }
        if (paRegistrationMessage != null) {
            message.append(paRegistrationMessage);
        }
        if (fail && message.length() > 0) {
            Assert.fail((String)message.toString());
        }
        return message.toString();
    }

    public static void assertAndEnsureCleanDeploymentCache(ProcessEngine processEngine) {
        TestHelper.assertAndEnsureCleanDeploymentCache(processEngine, true);
    }

    public static String assertAndEnsureCleanDeploymentCache(ProcessEngine processEngine, boolean fail) {
        StringBuilder outputMessage = new StringBuilder();
        ProcessEngineConfigurationImpl processEngineConfiguration = ((ProcessEngineImpl)processEngine).getProcessEngineConfiguration();
        CachePurgeReport cachePurgeReport = processEngineConfiguration.getDeploymentCache().purgeCache();
        outputMessage.append(cachePurgeReport.getPurgeReportAsString());
        if (outputMessage.length() > 0) {
            outputMessage.insert(0, "Deployment cache not clean:\n");
            LOG.error(outputMessage.toString());
            if (fail) {
                Assert.fail((String)outputMessage.toString());
            }
            return outputMessage.toString();
        }
        LOG.debug("Deployment cache was clean");
        return null;
    }

    public static String assertAndEnsureNoProcessApplicationsRegistered(ProcessEngine processEngine) {
        ProcessEngineConfigurationImpl engineConfiguration = (ProcessEngineConfigurationImpl)processEngine.getProcessEngineConfiguration();
        ProcessApplicationManager processApplicationManager = engineConfiguration.getProcessApplicationManager();
        if (processApplicationManager.hasRegistrations()) {
            processApplicationManager.clearRegistrations();
            return "There are still process applications registered";
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForJobExecutorToProcessAllJobs(ProcessEngineConfigurationImpl processEngineConfiguration, long maxMillisToWait, long intervalMillis) {
        JobExecutor jobExecutor = processEngineConfiguration.getJobExecutor();
        jobExecutor.start();
        try {
            Timer timer = new Timer();
            InteruptTask task = new InteruptTask(Thread.currentThread());
            timer.schedule((TimerTask)task, maxMillisToWait);
            boolean areJobsAvailable = true;
            try {
                while (areJobsAvailable && !task.isTimeLimitExceeded()) {
                    Thread.sleep(intervalMillis);
                    areJobsAvailable = TestHelper.areJobsAvailable(processEngineConfiguration);
                }
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                timer.cancel();
            }
            if (areJobsAvailable) {
                throw new ProcessEngineException("time limit of " + maxMillisToWait + " was exceeded");
            }
        }
        finally {
            jobExecutor.shutdown();
        }
    }

    public static boolean areJobsAvailable(ProcessEngineConfigurationImpl processEngineConfiguration) {
        return !processEngineConfiguration.getManagementService().createJobQuery().executable().list().isEmpty();
    }

    public static void resetIdGenerator(ProcessEngineConfigurationImpl processEngineConfiguration) {
        IdGenerator idGenerator = processEngineConfiguration.getIdGenerator();
        if (idGenerator instanceof DbIdGenerator) {
            ((DbIdGenerator)idGenerator).reset();
        }
    }

    public static ProcessEngine getProcessEngine(String configurationResource) {
        ProcessEngine processEngine = processEngines.get(configurationResource);
        if (processEngine == null) {
            LOG.debug("==== BUILDING PROCESS ENGINE ========================================================================");
            processEngine = ProcessEngineConfiguration.createProcessEngineConfigurationFromResource(configurationResource).buildProcessEngine();
            LOG.debug("==== PROCESS ENGINE CREATED =========================================================================");
            processEngines.put(configurationResource, processEngine);
        }
        return processEngine;
    }

    public static void closeProcessEngines() {
        for (ProcessEngine processEngine : processEngines.values()) {
            processEngine.close();
        }
        processEngines.clear();
    }

    public static void createSchema(ProcessEngineConfigurationImpl processEngineConfiguration) {
        processEngineConfiguration.getCommandExecutorTxRequired().execute(commandContext -> {
            commandContext.getSession(PersistenceSession.class).dbSchemaCreate();
            return null;
        });
    }

    public static void dropSchema(ProcessEngineConfigurationImpl processEngineConfiguration) {
        processEngineConfiguration.getCommandExecutorTxRequired().execute(commandContext -> {
            commandContext.getDbSqlSession().dbSchemaDrop();
            return null;
        });
    }

    public static void createOrUpdateHistoryLevel(ProcessEngineConfigurationImpl processEngineConfiguration) {
        processEngineConfiguration.getCommandExecutorTxRequired().execute(commandContext -> {
            DbEntityManager dbEntityManager = commandContext.getDbEntityManager();
            PropertyEntity historyLevelProperty = dbEntityManager.selectById(PropertyEntity.class, "historyLevel");
            if (historyLevelProperty != null) {
                if (processEngineConfiguration.getHistoryLevel().getId() != new Integer(historyLevelProperty.getValue()).intValue()) {
                    historyLevelProperty.setValue(Integer.toString(processEngineConfiguration.getHistoryLevel().getId()));
                    dbEntityManager.merge(historyLevelProperty);
                }
            } else {
                HistoryLevelSetupCommand.dbCreateHistoryLevel(commandContext);
            }
            return null;
        });
    }

    public static void deleteHistoryLevel(ProcessEngineConfigurationImpl processEngineConfiguration) {
        processEngineConfiguration.getCommandExecutorTxRequired().execute(commandContext -> {
            DbEntityManager dbEntityManager = commandContext.getDbEntityManager();
            PropertyEntity historyLevelProperty = dbEntityManager.selectById(PropertyEntity.class, "historyLevel");
            if (historyLevelProperty != null) {
                dbEntityManager.delete(historyLevelProperty);
            }
            return null;
        });
    }

    public static void clearUserOperationLog(ProcessEngineConfigurationImpl processEngineConfiguration) {
        if (processEngineConfiguration.getHistoryLevel().equals(HistoryLevel.HISTORY_LEVEL_FULL)) {
            HistoryService historyService = processEngineConfiguration.getHistoryService();
            List logs = historyService.createUserOperationLogQuery().list();
            for (UserOperationLogEntry log : logs) {
                historyService.deleteUserOperationLogEntry(log.getId());
            }
        }
    }

    public static void deleteTelemetryProperty(ProcessEngineConfigurationImpl processEngineConfiguration) {
        processEngineConfiguration.getCommandExecutorTxRequired().execute(commandContext -> {
            DbEntityManager dbEntityManager = commandContext.getDbEntityManager();
            PropertyEntity telemetryProperty = dbEntityManager.selectById(PropertyEntity.class, "camunda.telemetry.enabled");
            if (telemetryProperty != null) {
                dbEntityManager.delete(telemetryProperty);
            }
            return null;
        });
    }

    public static void deleteInstallationId(ProcessEngineConfigurationImpl processEngineConfiguration) {
        processEngineConfiguration.getCommandExecutorTxRequired().execute(commandContext -> {
            DbEntityManager dbEntityManager = commandContext.getDbEntityManager();
            PropertyEntity installationIdProperty = dbEntityManager.selectById(PropertyEntity.class, "camunda.installation.id");
            if (installationIdProperty != null) {
                dbEntityManager.delete(installationIdProperty);
            }
            return null;
        });
    }

    public static Object defaultManualActivation() {
        FixedValue expression = new FixedValue(true);
        CaseControlRuleImpl caseControlRule = new CaseControlRuleImpl(expression);
        return caseControlRule;
    }

    static {
        RESOURCE_SUFFIXES.addAll(Arrays.asList(BpmnDeployer.BPMN_RESOURCE_SUFFIXES));
        RESOURCE_SUFFIXES.addAll(Arrays.asList(CmmnDeployer.CMMN_RESOURCE_SUFFIXES));
        RESOURCE_SUFFIXES.addAll(Arrays.asList(DecisionDefinitionDeployer.DMN_RESOURCE_SUFFIXES));
    }

    private static class InteruptTask
    extends TimerTask {
        protected boolean timeLimitExceeded = false;
        protected Thread thread;

        public InteruptTask(Thread thread) {
            this.thread = thread;
        }

        public boolean isTimeLimitExceeded() {
            return this.timeLimitExceeded;
        }

        @Override
        public void run() {
            this.timeLimitExceeded = true;
            this.thread.interrupt();
        }
    }
}

