/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.batch.builder;

import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.impl.batch.BatchConfiguration;
import org.camunda.bpm.engine.impl.batch.BatchEntity;
import org.camunda.bpm.engine.impl.batch.BatchJobHandler;
import org.camunda.bpm.engine.impl.batch.DeploymentMapping;
import org.camunda.bpm.engine.impl.batch.builder.OperationLogHandler;
import org.camunda.bpm.engine.impl.batch.builder.OperationLogInstanceCountHandler;
import org.camunda.bpm.engine.impl.batch.builder.PermissionHandler;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.jobexecutor.JobHandler;

public class BatchBuilder {
    protected CommandContext commandContext;
    protected BatchConfiguration config;
    protected String tenantId;
    protected String type;
    protected Integer totalJobsCount;
    protected Permission permission;
    protected PermissionHandler permissionHandler;
    protected OperationLogInstanceCountHandler operationLogInstanceCountHandler;
    protected OperationLogHandler operationLogHandler;

    public BatchBuilder(CommandContext commandContext) {
        this.commandContext = commandContext;
    }

    public BatchBuilder tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public BatchBuilder config(BatchConfiguration config) {
        this.config = config;
        return this;
    }

    public BatchBuilder type(String batchType) {
        this.type = batchType;
        return this;
    }

    public BatchBuilder totalJobs(int totalJobsCount) {
        this.totalJobsCount = totalJobsCount;
        return this;
    }

    public BatchBuilder permission(Permission permission) {
        this.permission = permission;
        return this;
    }

    public BatchBuilder permissionHandler(PermissionHandler permissionCheckHandler) {
        this.permissionHandler = permissionCheckHandler;
        return this;
    }

    public BatchBuilder operationLogHandler(OperationLogInstanceCountHandler operationLogHandler) {
        this.operationLogInstanceCountHandler = operationLogHandler;
        return this;
    }

    public BatchBuilder operationLogHandler(OperationLogHandler operationLogHandler) {
        this.operationLogHandler = operationLogHandler;
        return this;
    }

    public Batch build() {
        this.checkPermissions();
        BatchEntity batch = new BatchEntity();
        this.configure(batch);
        this.save(batch);
        this.writeOperationLog();
        return batch;
    }

    protected void checkPermissions() {
        if (this.permission == null && this.permissionHandler == null) {
            throw new ProcessEngineException("No permission check performed!");
        }
        if (this.permission != null) {
            this.commandContext.getProcessEngineConfiguration().getCommandCheckers().forEach(checker -> checker.checkCreateBatch(this.permission));
        }
        if (this.permissionHandler != null) {
            this.permissionHandler.check(this.commandContext);
        }
    }

    protected BatchEntity configure(BatchEntity batch) {
        ProcessEngineConfigurationImpl engineConfig = this.commandContext.getProcessEngineConfiguration();
        Map<String, JobHandler> jobHandlers = engineConfig.getJobHandlers();
        BatchJobHandler jobHandler = (BatchJobHandler)jobHandlers.get(this.type);
        String type = jobHandler.getType();
        batch.setType(type);
        int invocationPerBatchJobCount = this.calculateInvocationsPerBatchJob(type);
        batch.setInvocationsPerBatchJob(invocationPerBatchJobCount);
        batch.setTenantId(this.tenantId);
        byte[] configAsBytes = jobHandler.writeConfiguration(this.config);
        batch.setConfigurationBytes(configAsBytes);
        this.setTotalJobs(batch, invocationPerBatchJobCount);
        int jobCount = engineConfig.getBatchJobsPerSeed();
        batch.setBatchJobsPerSeed(jobCount);
        return batch;
    }

    protected void setTotalJobs(BatchEntity batch, int invocationPerBatchJobCount) {
        if (this.totalJobsCount != null) {
            batch.setTotalJobs(this.totalJobsCount);
        } else {
            List<String> instanceIds = this.config.getIds();
            int instanceCount = instanceIds.size();
            int totalJobsCount = this.calculateTotalJobs(instanceCount, invocationPerBatchJobCount);
            batch.setTotalJobs(totalJobsCount);
        }
    }

    protected void save(BatchEntity batch) {
        this.commandContext.getBatchManager().insertBatch(batch);
        String seedDeploymentId = null;
        if (this.config.getIdMappings() != null && !this.config.getIdMappings().isEmpty()) {
            seedDeploymentId = ((DeploymentMapping)this.config.getIdMappings().get(0)).getDeploymentId();
        }
        batch.createSeedJobDefinition(seedDeploymentId);
        batch.createMonitorJobDefinition();
        batch.createBatchJobDefinition();
        batch.fireHistoricStartEvent();
        batch.createSeedJob();
    }

    protected void writeOperationLog() {
        if (this.operationLogInstanceCountHandler == null && this.operationLogHandler == null) {
            throw new ProcessEngineException("No operation log handler specified!");
        }
        if (this.operationLogInstanceCountHandler != null) {
            List<String> instanceIds = this.config.getIds();
            int instanceCount = instanceIds.size();
            this.operationLogInstanceCountHandler.write(this.commandContext, instanceCount);
        } else {
            this.operationLogHandler.write(this.commandContext);
        }
    }

    protected int calculateTotalJobs(int instanceCount, int invocationPerBatchJobCount) {
        if (instanceCount == 0 || invocationPerBatchJobCount == 0) {
            return 0;
        }
        if (instanceCount % invocationPerBatchJobCount == 0) {
            return instanceCount / invocationPerBatchJobCount;
        }
        return instanceCount / invocationPerBatchJobCount + 1;
    }

    protected int calculateInvocationsPerBatchJob(String batchType) {
        ProcessEngineConfigurationImpl engineConfig = this.commandContext.getProcessEngineConfiguration();
        Map<String, Integer> invocationsPerBatchJobByBatchType = engineConfig.getInvocationsPerBatchJobByBatchType();
        Integer invocationCount = invocationsPerBatchJobByBatchType.get(batchType);
        if (invocationCount != null) {
            return invocationCount;
        }
        return engineConfig.getInvocationsPerBatchJob();
    }
}

