/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.batch.job;

import java.util.List;
import org.camunda.bpm.engine.impl.batch.AbstractBatchJobHandler;
import org.camunda.bpm.engine.impl.batch.BatchJobConfiguration;
import org.camunda.bpm.engine.impl.batch.BatchJobContext;
import org.camunda.bpm.engine.impl.batch.BatchJobDeclaration;
import org.camunda.bpm.engine.impl.batch.SetRetriesBatchConfiguration;
import org.camunda.bpm.engine.impl.batch.job.SetJobRetriesBatchConfigurationJsonConverter;
import org.camunda.bpm.engine.impl.cmd.SetJobsRetriesCmd;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.jobexecutor.JobDeclaration;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.MessageEntity;

public class SetJobRetriesJobHandler
extends AbstractBatchJobHandler<SetRetriesBatchConfiguration> {
    public static final BatchJobDeclaration JOB_DECLARATION = new BatchJobDeclaration("set-job-retries");

    @Override
    public String getType() {
        return "set-job-retries";
    }

    protected SetJobRetriesBatchConfigurationJsonConverter getJsonConverterInstance() {
        return SetJobRetriesBatchConfigurationJsonConverter.INSTANCE;
    }

    @Override
    public JobDeclaration<BatchJobContext, MessageEntity> getJobDeclaration() {
        return JOB_DECLARATION;
    }

    @Override
    protected SetRetriesBatchConfiguration createJobConfiguration(SetRetriesBatchConfiguration configuration, List<String> jobIds) {
        return new SetRetriesBatchConfiguration(jobIds, configuration.getRetries());
    }

    @Override
    public void execute(BatchJobConfiguration configuration, ExecutionEntity execution, CommandContext commandContext, String tenantId) {
        ByteArrayEntity configurationEntity = commandContext.getDbEntityManager().selectById(ByteArrayEntity.class, configuration.getConfigurationByteArrayId());
        SetRetriesBatchConfiguration batchConfiguration = (SetRetriesBatchConfiguration)this.readConfiguration(configurationEntity.getBytes());
        commandContext.executeWithOperationLogPrevented(new SetJobsRetriesCmd(batchConfiguration.getIds(), batchConfiguration.getRetries()));
        commandContext.getByteArrayManager().delete(configurationEntity);
    }
}

