/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.impl.cmd.AbstractInstanceCancellationCmd;
import org.camunda.bpm.engine.impl.cmd.GetActivityInstanceCmd;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.TransitionInstance;

public class TransitionInstanceCancellationCmd
extends AbstractInstanceCancellationCmd {
    protected String transitionInstanceId;

    public TransitionInstanceCancellationCmd(String processInstanceId, String transitionInstanceId) {
        super(processInstanceId);
        this.transitionInstanceId = transitionInstanceId;
    }

    public String getTransitionInstanceId() {
        return this.transitionInstanceId;
    }

    @Override
    protected ExecutionEntity determineSourceInstanceExecution(CommandContext commandContext) {
        ActivityInstance instance = commandContext.runWithoutAuthorization(new GetActivityInstanceCmd(this.processInstanceId));
        TransitionInstance instanceToCancel = this.findTransitionInstance(instance, this.transitionInstanceId);
        EnsureUtil.ensureNotNull(NotValidException.class, this.describeFailure("Transition instance '" + this.transitionInstanceId + "' does not exist"), "transitionInstance", (Object)instanceToCancel);
        ExecutionEntity transitionExecution = commandContext.getExecutionManager().findExecutionById(instanceToCancel.getExecutionId());
        return transitionExecution;
    }

    @Override
    protected String describe() {
        return "Cancel transition instance '" + this.transitionInstanceId + "'";
    }
}

