/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.dmn.cmd;

import java.util.ArrayList;
import org.camunda.bpm.dmn.engine.DmnDecisionTableResult;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.cfg.CommandChecker;
import org.camunda.bpm.engine.impl.dmn.DecisionTableEvaluationBuilderImpl;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.deploy.cache.DeploymentCache;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyChange;
import org.camunda.bpm.engine.impl.util.DecisionEvaluationUtil;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;

public class EvaluateDecisionTableCmd
implements Command<DmnDecisionTableResult> {
    protected String decisionDefinitionKey;
    protected String decisionDefinitionId;
    protected Integer version;
    protected VariableMap variables;
    protected String decisionDefinitionTenantId;
    protected boolean isTenandIdSet;

    public EvaluateDecisionTableCmd(DecisionTableEvaluationBuilderImpl builder) {
        this.decisionDefinitionKey = builder.getDecisionDefinitionKey();
        this.decisionDefinitionId = builder.getDecisionDefinitionId();
        this.version = builder.getVersion();
        this.variables = Variables.fromMap(builder.getVariables());
        this.decisionDefinitionTenantId = builder.getDecisionDefinitionTenantId();
        this.isTenandIdSet = builder.isTenantIdSet();
    }

    @Override
    public DmnDecisionTableResult execute(CommandContext commandContext) {
        EnsureUtil.ensureOnlyOneNotNull("either decision definition id or key must be set", this.decisionDefinitionId, this.decisionDefinitionKey);
        DecisionDefinition decisionDefinition = this.getDecisionDefinition(commandContext);
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkEvaluateDecision(decisionDefinition);
        }
        this.writeUserOperationLog(commandContext, decisionDefinition);
        return this.doEvaluateDecision(decisionDefinition, this.variables);
    }

    protected void writeUserOperationLog(CommandContext commandContext, DecisionDefinition decisionDefinition) {
        ArrayList<PropertyChange> propertyChanges = new ArrayList<PropertyChange>();
        propertyChanges.add(new PropertyChange("decisionDefinitionId", null, decisionDefinition.getId()));
        propertyChanges.add(new PropertyChange("decisionDefinitionKey", null, decisionDefinition.getKey()));
        commandContext.getOperationLogManager().logDecisionDefinitionOperation("Evaluate", propertyChanges);
    }

    protected DmnDecisionTableResult doEvaluateDecision(DecisionDefinition decisionDefinition, VariableMap variables) {
        try {
            return DecisionEvaluationUtil.evaluateDecisionTable(decisionDefinition, variables);
        }
        catch (Exception e) {
            throw new ProcessEngineException("Exception while evaluating decision with key '" + this.decisionDefinitionKey + "'", e);
        }
    }

    protected DecisionDefinition getDecisionDefinition(CommandContext commandContext) {
        DeploymentCache deploymentCache = commandContext.getProcessEngineConfiguration().getDeploymentCache();
        if (this.decisionDefinitionId != null) {
            return this.findById(deploymentCache);
        }
        return this.findByKey(deploymentCache);
    }

    protected DecisionDefinition findById(DeploymentCache deploymentCache) {
        return deploymentCache.findDeployedDecisionDefinitionById(this.decisionDefinitionId);
    }

    protected DecisionDefinition findByKey(DeploymentCache deploymentCache) {
        DecisionDefinition decisionDefinition = null;
        if (this.version == null && !this.isTenandIdSet) {
            decisionDefinition = deploymentCache.findDeployedLatestDecisionDefinitionByKey(this.decisionDefinitionKey);
        } else if (this.version == null && this.isTenandIdSet) {
            decisionDefinition = deploymentCache.findDeployedLatestDecisionDefinitionByKeyAndTenantId(this.decisionDefinitionKey, this.decisionDefinitionTenantId);
        } else if (this.version != null && !this.isTenandIdSet) {
            decisionDefinition = deploymentCache.findDeployedDecisionDefinitionByKeyAndVersion(this.decisionDefinitionKey, this.version);
        } else if (this.version != null && this.isTenandIdSet) {
            decisionDefinition = deploymentCache.findDeployedDecisionDefinitionByKeyVersionAndTenantId(this.decisionDefinitionKey, this.version, this.decisionDefinitionTenantId);
        }
        return decisionDefinition;
    }
}

