/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.jobexecutor;

import java.util.HashMap;
import java.util.Map;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.jobexecutor.JobHandler;
import org.camunda.bpm.engine.impl.jobexecutor.JobHandlerConfiguration;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.TransitionImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.LegacyBehavior;
import org.camunda.bpm.engine.impl.pvm.runtime.operation.PvmAtomicOperation;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class AsyncContinuationJobHandler
implements JobHandler<AsyncContinuationConfiguration> {
    public static final String TYPE = "async-continuation";
    private Map<String, PvmAtomicOperation> supportedOperations = new HashMap<String, PvmAtomicOperation>();

    public AsyncContinuationJobHandler() {
        this.supportedOperations.put(PvmAtomicOperation.TRANSITION_CREATE_SCOPE.getCanonicalName(), PvmAtomicOperation.TRANSITION_CREATE_SCOPE);
        this.supportedOperations.put(PvmAtomicOperation.ACTIVITY_START_CREATE_SCOPE.getCanonicalName(), PvmAtomicOperation.ACTIVITY_START_CREATE_SCOPE);
        this.supportedOperations.put(PvmAtomicOperation.PROCESS_START.getCanonicalName(), PvmAtomicOperation.PROCESS_START);
        this.supportedOperations.put(PvmAtomicOperation.TRANSITION_NOTIFY_LISTENER_TAKE.getCanonicalName(), PvmAtomicOperation.TRANSITION_NOTIFY_LISTENER_TAKE);
        this.supportedOperations.put(PvmAtomicOperation.ACTIVITY_END.getCanonicalName(), PvmAtomicOperation.ACTIVITY_END);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void execute(AsyncContinuationConfiguration configuration, ExecutionEntity execution, CommandContext commandContext, String tenantId) {
        LegacyBehavior.repairMultiInstanceAsyncJob(execution);
        PvmAtomicOperation atomicOperation = this.findMatchingAtomicOperation(configuration.getAtomicOperation());
        EnsureUtil.ensureNotNull("Cannot process job with configuration " + configuration, "atomicOperation", (Object)atomicOperation);
        String transitionId = configuration.getTransitionId();
        if (transitionId != null) {
            ActivityImpl activity = execution.getActivity();
            TransitionImpl transition = (TransitionImpl)activity.findOutgoingTransition(transitionId);
            execution.setTransition(transition);
        }
        Context.getCommandInvocationContext().performOperation(atomicOperation, execution);
    }

    public PvmAtomicOperation findMatchingAtomicOperation(String operationName) {
        if (operationName == null) {
            return PvmAtomicOperation.TRANSITION_CREATE_SCOPE;
        }
        return this.supportedOperations.get(operationName);
    }

    protected boolean isSupported(PvmAtomicOperation atomicOperation) {
        return this.supportedOperations.containsKey(atomicOperation.getCanonicalName());
    }

    @Override
    public AsyncContinuationConfiguration newConfiguration(String canonicalString) {
        String[] configParts = this.tokenizeJobConfiguration(canonicalString);
        AsyncContinuationConfiguration configuration = new AsyncContinuationConfiguration();
        configuration.setAtomicOperation(configParts[0]);
        configuration.setTransitionId(configParts[1]);
        return configuration;
    }

    protected String[] tokenizeJobConfiguration(String jobConfiguration) {
        String[] configuration = new String[2];
        if (jobConfiguration != null) {
            String[] configParts = jobConfiguration.split("\\$");
            if (configuration.length > 2) {
                throw new ProcessEngineException("Illegal async continuation job handler configuration: '" + jobConfiguration + "': exprecting one part or two parts seperated by '$'.");
            }
            configuration[0] = configParts[0];
            if (configParts.length == 2) {
                configuration[1] = configParts[1];
            }
        }
        return configuration;
    }

    @Override
    public void onDelete(AsyncContinuationConfiguration configuration, JobEntity jobEntity) {
    }

    public static class AsyncContinuationConfiguration
    implements JobHandlerConfiguration {
        protected String atomicOperation;
        protected String transitionId;

        public String getAtomicOperation() {
            return this.atomicOperation;
        }

        public void setAtomicOperation(String atomicOperation) {
            this.atomicOperation = atomicOperation;
        }

        public String getTransitionId() {
            return this.transitionId;
        }

        public void setTransitionId(String transitionId) {
            this.transitionId = transitionId;
        }

        @Override
        public String toCanonicalString() {
            String configuration = this.atomicOperation;
            if (this.transitionId != null) {
                configuration = configuration + "$" + this.transitionId;
            }
            return configuration;
        }
    }
}

