/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.delegate;

import java.util.concurrent.Callable;
import org.camunda.bpm.application.InvocationContext;
import org.camunda.bpm.application.ProcessApplicationReference;
import org.camunda.bpm.engine.delegate.BaseDelegateExecution;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cmmn.entity.runtime.CaseExecutionEntity;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.context.CoreExecutionContext;
import org.camunda.bpm.engine.impl.context.ProcessApplicationContextUtil;
import org.camunda.bpm.engine.impl.core.instance.CoreExecution;
import org.camunda.bpm.engine.impl.delegate.DelegateInvocation;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.DelegateInterceptor;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.repository.ResourceDefinitionEntity;

public class DefaultDelegateInterceptor
implements DelegateInterceptor {
    @Override
    public void handleInvocation(final DelegateInvocation invocation) throws Exception {
        ProcessApplicationReference processApplication = this.getProcessApplicationForInvocation(invocation);
        if (processApplication != null && ProcessApplicationContextUtil.requiresContextSwitch(processApplication)) {
            Context.executeWithinProcessApplication(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    DefaultDelegateInterceptor.this.handleInvocation(invocation);
                    return null;
                }
            }, processApplication, new InvocationContext(invocation.getContextExecution()));
        } else {
            this.handleInvocationInContext(invocation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleInvocationInContext(DelegateInvocation invocation) throws Exception {
        CommandContext commandContext = Context.getCommandContext();
        boolean wasAuthorizationCheckEnabled = commandContext.isAuthorizationCheckEnabled();
        boolean wasUserOperationLogEnabled = commandContext.isUserOperationLogEnabled();
        BaseDelegateExecution contextExecution = invocation.getContextExecution();
        ProcessEngineConfigurationImpl configuration = Context.getProcessEngineConfiguration();
        boolean popExecutionContext = false;
        try {
            if (!configuration.isAuthorizationEnabledForCustomCode()) {
                commandContext.disableAuthorizationCheck();
            }
            try {
                commandContext.disableUserOperationLog();
                try {
                    if (contextExecution != null && !this.isCurrentContextExecution(contextExecution)) {
                        popExecutionContext = this.setExecutionContext(contextExecution);
                    }
                    invocation.proceed();
                }
                finally {
                    if (popExecutionContext) {
                        Context.removeExecutionContext();
                    }
                }
            }
            finally {
                if (wasUserOperationLogEnabled) {
                    commandContext.enableUserOperationLog();
                }
            }
        }
        finally {
            if (wasAuthorizationCheckEnabled) {
                commandContext.enableAuthorizationCheck();
            }
        }
    }

    protected boolean setExecutionContext(BaseDelegateExecution execution) {
        if (execution instanceof ExecutionEntity) {
            Context.setExecutionContext((ExecutionEntity)execution);
            return true;
        }
        if (execution instanceof CaseExecutionEntity) {
            Context.setExecutionContext((CaseExecutionEntity)execution);
            return true;
        }
        return false;
    }

    protected boolean isCurrentContextExecution(BaseDelegateExecution execution) {
        CoreExecutionContext<? extends CoreExecution> coreExecutionContext = Context.getCoreExecutionContext();
        return coreExecutionContext != null && coreExecutionContext.getExecution() == execution;
    }

    protected ProcessApplicationReference getProcessApplicationForInvocation(DelegateInvocation invocation) {
        BaseDelegateExecution contextExecution = invocation.getContextExecution();
        ResourceDefinitionEntity contextResource = invocation.getContextResource();
        if (contextExecution != null) {
            return ProcessApplicationContextUtil.getTargetProcessApplication((CoreExecution)contextExecution);
        }
        if (contextResource != null) {
            return ProcessApplicationContextUtil.getTargetProcessApplication(contextResource);
        }
        return null;
    }
}

