/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.scripting.engine;

import java.util.ArrayList;
import java.util.List;
import javax.script.Bindings;
import org.camunda.bpm.engine.delegate.VariableScope;
import org.camunda.bpm.engine.impl.scripting.engine.Resolver;
import org.camunda.bpm.engine.impl.scripting.engine.ResolverFactory;
import org.camunda.bpm.engine.impl.scripting.engine.ScriptBindings;

public class ScriptBindingsFactory {
    protected List<ResolverFactory> resolverFactories;

    public ScriptBindingsFactory(List<ResolverFactory> resolverFactories) {
        this.resolverFactories = resolverFactories;
    }

    public Bindings createBindings(VariableScope variableScope, Bindings engineBindings) {
        ArrayList<Resolver> scriptResolvers = new ArrayList<Resolver>();
        for (ResolverFactory scriptResolverFactory : this.resolverFactories) {
            Resolver resolver = scriptResolverFactory.createResolver(variableScope);
            if (resolver == null) continue;
            scriptResolvers.add(resolver);
        }
        return new ScriptBindings(scriptResolvers, variableScope, engineBindings);
    }

    public List<ResolverFactory> getResolverFactories() {
        return this.resolverFactories;
    }

    public void setResolverFactories(List<ResolverFactory> resolverFactories) {
        this.resolverFactories = resolverFactories;
    }
}

