/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.ProcessEngineInfo;
import org.camunda.bpm.engine.impl.ProcessEngineInfoImpl;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.util.IoUtil;
import org.camunda.bpm.engine.impl.util.ReflectUtil;

public abstract class ProcessEngines {
    private static final ProcessEngineLogger LOG = ProcessEngineLogger.INSTANCE;
    public static final String NAME_DEFAULT = "default";
    protected static boolean isInitialized = false;
    protected static Map<String, ProcessEngine> processEngines = new HashMap<String, ProcessEngine>();
    protected static Map<String, ProcessEngineInfo> processEngineInfosByName = new HashMap<String, ProcessEngineInfo>();
    protected static Map<String, ProcessEngineInfo> processEngineInfosByResourceUrl = new HashMap<String, ProcessEngineInfo>();
    protected static List<ProcessEngineInfo> processEngineInfos = new ArrayList<ProcessEngineInfo>();

    public static synchronized void init() {
        ProcessEngines.init(true);
    }

    public static synchronized void init(boolean forceCreate) {
        if (!isInitialized) {
            if (processEngines == null) {
                processEngines = new HashMap<String, ProcessEngine>();
            }
            ClassLoader classLoader = ReflectUtil.getClassLoader();
            Enumeration<URL> resources = null;
            try {
                resources = classLoader.getResources("camunda.cfg.xml");
            }
            catch (IOException e) {
                try {
                    resources = classLoader.getResources("activiti.cfg.xml");
                }
                catch (IOException ex) {
                    if (forceCreate) {
                        throw new ProcessEngineException("problem retrieving camunda.cfg.xml and activiti.cfg.xml resources on the classpath: " + System.getProperty("java.class.path"), ex);
                    }
                    return;
                }
            }
            HashSet<URL> configUrls = new HashSet<URL>();
            while (resources.hasMoreElements()) {
                configUrls.add(resources.nextElement());
            }
            for (URL resource : configUrls) {
                ProcessEngines.initProcessEngineFromResource(resource);
            }
            try {
                resources = classLoader.getResources("activiti-context.xml");
            }
            catch (IOException e) {
                if (forceCreate) {
                    throw new ProcessEngineException("problem retrieving activiti-context.xml resources on the classpath: " + System.getProperty("java.class.path"), e);
                }
                return;
            }
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                ProcessEngines.initProcessEngineFromSpringResource(resource);
            }
            isInitialized = true;
        } else {
            LOG.processEngineAlreadyInitialized();
        }
    }

    protected static void initProcessEngineFromSpringResource(URL resource) {
        try {
            Class<?> springConfigurationHelperClass = ReflectUtil.loadClass("org.camunda.bpm.engine.spring.SpringConfigurationHelper");
            Method method = springConfigurationHelperClass.getMethod("buildProcessEngine", URL.class);
            ProcessEngine processEngine = (ProcessEngine)method.invoke(null, resource);
            String processEngineName = processEngine.getName();
            ProcessEngineInfoImpl processEngineInfo = new ProcessEngineInfoImpl(processEngineName, resource.toString(), null);
            processEngineInfosByName.put(processEngineName, processEngineInfo);
            processEngineInfosByResourceUrl.put(resource.toString(), processEngineInfo);
        }
        catch (Exception e) {
            throw new ProcessEngineException("couldn't initialize process engine from spring configuration resource " + resource.toString() + ": " + e.getMessage(), e);
        }
    }

    public static void registerProcessEngine(ProcessEngine processEngine) {
        processEngines.put(processEngine.getName(), processEngine);
    }

    public static void unregister(ProcessEngine processEngine) {
        processEngines.remove(processEngine.getName());
    }

    private static ProcessEngineInfo initProcessEngineFromResource(URL resourceUrl) {
        ProcessEngineInfo processEngineInfo = processEngineInfosByResourceUrl.get(resourceUrl);
        if (processEngineInfo != null) {
            processEngineInfos.remove(processEngineInfo);
            if (processEngineInfo.getException() == null) {
                String processEngineName = processEngineInfo.getName();
                processEngines.remove(processEngineName);
                processEngineInfosByName.remove(processEngineName);
            }
            processEngineInfosByResourceUrl.remove(processEngineInfo.getResourceUrl());
        }
        String resourceUrlString = resourceUrl.toString();
        try {
            LOG.initializingProcessEngineForResource(resourceUrl);
            ProcessEngine processEngine = ProcessEngines.buildProcessEngine(resourceUrl);
            String processEngineName = processEngine.getName();
            LOG.initializingProcessEngine(processEngine.getName());
            processEngineInfo = new ProcessEngineInfoImpl(processEngineName, resourceUrlString, null);
            processEngines.put(processEngineName, processEngine);
            processEngineInfosByName.put(processEngineName, processEngineInfo);
        }
        catch (Throwable e) {
            LOG.exceptionWhileInitializingProcessengine(e);
            processEngineInfo = new ProcessEngineInfoImpl(null, resourceUrlString, ProcessEngines.getExceptionString(e));
        }
        processEngineInfosByResourceUrl.put(resourceUrlString, processEngineInfo);
        processEngineInfos.add(processEngineInfo);
        return processEngineInfo;
    }

    private static String getExceptionString(Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }

    private static ProcessEngine buildProcessEngine(URL resource) {
        InputStream inputStream = null;
        try {
            inputStream = resource.openStream();
            ProcessEngineConfiguration processEngineConfiguration = ProcessEngineConfiguration.createProcessEngineConfigurationFromInputStream(inputStream);
            ProcessEngine processEngine = processEngineConfiguration.buildProcessEngine();
            return processEngine;
        }
        catch (IOException e) {
            throw new ProcessEngineException("couldn't open resource stream: " + e.getMessage(), e);
        }
        finally {
            IoUtil.closeSilently(inputStream);
        }
    }

    public static List<ProcessEngineInfo> getProcessEngineInfos() {
        return processEngineInfos;
    }

    public static ProcessEngineInfo getProcessEngineInfo(String processEngineName) {
        return processEngineInfosByName.get(processEngineName);
    }

    public static ProcessEngine getDefaultProcessEngine() {
        return ProcessEngines.getDefaultProcessEngine(true);
    }

    public static ProcessEngine getDefaultProcessEngine(boolean forceCreate) {
        return ProcessEngines.getProcessEngine(NAME_DEFAULT, forceCreate);
    }

    public static ProcessEngine getProcessEngine(String processEngineName) {
        return ProcessEngines.getProcessEngine(processEngineName, true);
    }

    public static ProcessEngine getProcessEngine(String processEngineName, boolean forceCreate) {
        if (!isInitialized) {
            ProcessEngines.init(forceCreate);
        }
        return processEngines.get(processEngineName);
    }

    public static ProcessEngineInfo retry(String resourceUrl) {
        try {
            return ProcessEngines.initProcessEngineFromResource(new URL(resourceUrl));
        }
        catch (MalformedURLException e) {
            throw new ProcessEngineException("invalid url: " + resourceUrl, e);
        }
    }

    public static Map<String, ProcessEngine> getProcessEngines() {
        return processEngines;
    }

    public static synchronized void destroy() {
        if (isInitialized) {
            HashMap<String, ProcessEngine> engines = new HashMap<String, ProcessEngine>(processEngines);
            processEngines = new HashMap<String, ProcessEngine>();
            for (String processEngineName : engines.keySet()) {
                ProcessEngine processEngine = (ProcessEngine)engines.get(processEngineName);
                try {
                    processEngine.close();
                }
                catch (Exception e) {
                    LOG.exceptionWhileClosingProcessEngine(processEngineName == null ? "the default process engine" : "process engine " + processEngineName, e);
                }
            }
            processEngineInfosByName.clear();
            processEngineInfosByResourceUrl.clear();
            processEngineInfos.clear();
            isInitialized = false;
        }
    }
}

