/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import org.camunda.bpm.engine.impl.cfg.CommandChecker;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyChange;

public class DeleteMetricsCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected Date timestamp;
    protected String reporter;

    public DeleteMetricsCmd(Date timestamp, String reporter) {
        this.timestamp = timestamp;
        this.reporter = reporter;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        commandContext.getAuthorizationManager().checkCamundaAdminOrPermission(CommandChecker::checkDeleteMetrics);
        this.writeUserOperationLog(commandContext);
        if (this.timestamp == null && this.reporter == null) {
            commandContext.getMeterLogManager().deleteAll();
        } else {
            commandContext.getMeterLogManager().deleteByTimestampAndReporter(this.timestamp, this.reporter);
        }
        return null;
    }

    protected void writeUserOperationLog(CommandContext commandContext) {
        ArrayList<PropertyChange> propertyChanges = new ArrayList<PropertyChange>();
        if (this.timestamp != null) {
            propertyChanges.add(new PropertyChange("timestamp", null, this.timestamp));
        }
        if (this.reporter != null) {
            propertyChanges.add(new PropertyChange("reporter", null, this.reporter));
        }
        if (propertyChanges.isEmpty()) {
            propertyChanges.add(PropertyChange.EMPTY_CHANGE);
        }
        commandContext.getOperationLogManager().logMetricsOperation("Delete", propertyChanges);
    }
}

