/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.io.Serializable;
import java.util.Arrays;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.exception.NotFoundException;
import org.camunda.bpm.engine.impl.cfg.CommandChecker;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyChange;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class DeleteHistoricVariableInstancesByProcessInstanceIdCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    private String processInstanceId;

    public DeleteHistoricVariableInstancesByProcessInstanceIdCmd(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        EnsureUtil.ensureNotEmpty(BadUserRequestException.class, "processInstanceId", this.processInstanceId);
        HistoricProcessInstanceEntity instance = commandContext.getHistoricProcessInstanceManager().findHistoricProcessInstance(this.processInstanceId);
        EnsureUtil.ensureNotNull(NotFoundException.class, "No historic process instance found with id: " + this.processInstanceId, "instance", (Object)instance);
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkDeleteHistoricVariableInstancesByProcessInstance(instance);
        }
        commandContext.getHistoricDetailManager().deleteHistoricDetailsByProcessInstanceIds(Arrays.asList(this.processInstanceId));
        commandContext.getHistoricVariableInstanceManager().deleteHistoricVariableInstanceByProcessInstanceIds(Arrays.asList(this.processInstanceId));
        ProcessDefinitionEntity definition = null;
        try {
            definition = commandContext.getProcessEngineConfiguration().getDeploymentCache().findDeployedProcessDefinitionById(instance.getProcessDefinitionId());
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        commandContext.getOperationLogManager().logHistoricVariableOperation("DeleteHistory", instance, definition, PropertyChange.EMPTY_CHANGE);
        return null;
    }
}

