/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.container.impl.tomcat;

import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.core.StandardServer;
import org.camunda.bpm.container.RuntimeContainerDelegate;
import org.camunda.bpm.container.impl.ContainerIntegrationLogger;
import org.camunda.bpm.container.impl.RuntimeContainerDelegateImpl;
import org.camunda.bpm.container.impl.deployment.DiscoverBpmPlatformPluginsStep;
import org.camunda.bpm.container.impl.deployment.PlatformXmlStartProcessEnginesStep;
import org.camunda.bpm.container.impl.deployment.StopProcessApplicationsStep;
import org.camunda.bpm.container.impl.deployment.StopProcessEnginesStep;
import org.camunda.bpm.container.impl.deployment.UnregisterBpmPlatformPluginsStep;
import org.camunda.bpm.container.impl.deployment.jobexecutor.StartJobExecutorStep;
import org.camunda.bpm.container.impl.deployment.jobexecutor.StartManagedThreadPoolStep;
import org.camunda.bpm.container.impl.deployment.jobexecutor.StopJobExecutorStep;
import org.camunda.bpm.container.impl.deployment.jobexecutor.StopManagedThreadPoolStep;
import org.camunda.bpm.container.impl.tomcat.deployment.TomcatParseBpmPlatformXmlStep;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;

public class TomcatBpmPlatformBootstrap
implements LifecycleListener {
    private static final ContainerIntegrationLogger LOG = ProcessEngineLogger.CONTAINER_INTEGRATION_LOGGER;
    protected ProcessEngine processEngine;
    protected RuntimeContainerDelegateImpl containerDelegate;

    public void lifecycleEvent(LifecycleEvent event) {
        if ("start".equals(event.getType())) {
            this.containerDelegate = (RuntimeContainerDelegateImpl)RuntimeContainerDelegate.INSTANCE.get();
            this.deployBpmPlatform(event);
        } else if ("stop".equals(event.getType())) {
            this.undeployBpmPlatform(event);
        }
    }

    protected void deployBpmPlatform(LifecycleEvent event) {
        StandardServer server = (StandardServer)event.getSource();
        this.containerDelegate.getServiceContainer().createDeploymentOperation("deploy BPM platform").addAttachment("server", server).addStep(new TomcatParseBpmPlatformXmlStep()).addStep(new DiscoverBpmPlatformPluginsStep()).addStep(new StartManagedThreadPoolStep()).addStep(new StartJobExecutorStep()).addStep(new PlatformXmlStartProcessEnginesStep()).execute();
        LOG.camundaBpmPlatformSuccessfullyStarted(server.getServerInfo());
    }

    protected void undeployBpmPlatform(LifecycleEvent event) {
        StandardServer server = (StandardServer)event.getSource();
        this.containerDelegate.getServiceContainer().createUndeploymentOperation("undeploy BPM platform").addAttachment("server", server).addStep(new StopJobExecutorStep()).addStep(new StopManagedThreadPoolStep()).addStep(new StopProcessApplicationsStep()).addStep(new StopProcessEnginesStep()).addStep(new UnregisterBpmPlatformPluginsStep()).execute();
        LOG.camundaBpmPlatformStopped(server.getServerInfo());
    }
}

