/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.identity.Group;
import org.camunda.bpm.engine.impl.AbstractQuery;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.ProcessDefinitionQueryProperty;
import org.camunda.bpm.engine.impl.QueryOrderingProperty;
import org.camunda.bpm.engine.impl.bpmn.parser.BpmnParse;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.db.CompositePermissionCheck;
import org.camunda.bpm.engine.impl.db.PermissionCheck;
import org.camunda.bpm.engine.impl.event.EventType;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.SuspensionState;
import org.camunda.bpm.engine.impl.util.CompareUtil;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinitionQuery;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.instance.Documentation;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;

public class ProcessDefinitionQueryImpl
extends AbstractQuery<ProcessDefinitionQuery, ProcessDefinition>
implements ProcessDefinitionQuery {
    private static final long serialVersionUID = 1L;
    protected String id;
    protected String[] ids;
    protected String category;
    protected String categoryLike;
    protected String name;
    protected String nameLike;
    protected String deploymentId;
    protected Date deployedAfter;
    protected Date deployedAt;
    protected String key;
    protected String[] keys;
    protected String keyLike;
    protected String resourceName;
    protected String resourceNameLike;
    protected Integer version;
    protected boolean latest = false;
    protected SuspensionState suspensionState;
    protected String authorizationUserId;
    protected List<String> cachedCandidateGroups;
    protected String procDefId;
    protected String incidentType;
    protected String incidentId;
    protected String incidentMessage;
    protected String incidentMessageLike;
    protected String eventSubscriptionName;
    protected String eventSubscriptionType;
    protected boolean isTenantIdSet = false;
    protected String[] tenantIds;
    protected boolean includeDefinitionsWithoutTenantId = false;
    protected boolean isVersionTagSet = false;
    protected String versionTag;
    protected String versionTagLike;
    protected String processDefinitionIdAfter;
    protected boolean isStartableInTasklist = false;
    protected boolean isNotStartableInTasklist = false;
    protected boolean startablePermissionCheck = false;
    protected List<PermissionCheck> processDefinitionCreatePermissionChecks = new ArrayList<PermissionCheck>();
    private boolean shouldJoinDeploymentTable = false;

    public ProcessDefinitionQueryImpl() {
    }

    public ProcessDefinitionQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    @Override
    public ProcessDefinitionQuery processDefinitionId(String processDefinitionId) {
        this.id = processDefinitionId;
        return this;
    }

    public ProcessDefinitionQueryImpl idAfter(String processDefinitionId) {
        this.processDefinitionIdAfter = processDefinitionId;
        return this;
    }

    public String getProcessDefinitionIdAfter() {
        return this.processDefinitionIdAfter;
    }

    @Override
    public ProcessDefinitionQuery processDefinitionIdIn(String ... ids) {
        this.ids = ids;
        return this;
    }

    @Override
    public ProcessDefinitionQuery processDefinitionCategory(String category) {
        EnsureUtil.ensureNotNull("category", (Object)category);
        this.category = category;
        return this;
    }

    @Override
    public ProcessDefinitionQuery processDefinitionCategoryLike(String categoryLike) {
        EnsureUtil.ensureNotNull("categoryLike", (Object)categoryLike);
        this.categoryLike = categoryLike;
        return this;
    }

    @Override
    public ProcessDefinitionQuery processDefinitionName(String name) {
        EnsureUtil.ensureNotNull("name", (Object)name);
        this.name = name;
        return this;
    }

    @Override
    public ProcessDefinitionQuery processDefinitionNameLike(String nameLike) {
        EnsureUtil.ensureNotNull("nameLike", (Object)nameLike);
        this.nameLike = nameLike;
        return this;
    }

    @Override
    public ProcessDefinitionQuery deploymentId(String deploymentId) {
        EnsureUtil.ensureNotNull("deploymentId", (Object)deploymentId);
        this.deploymentId = deploymentId;
        return this;
    }

    @Override
    public ProcessDefinitionQuery deployedAfter(Date deployedAfter) {
        EnsureUtil.ensureNotNull("deployedAfter", (Object)deployedAfter);
        this.shouldJoinDeploymentTable = true;
        this.deployedAfter = deployedAfter;
        return this;
    }

    @Override
    public ProcessDefinitionQuery deployedAt(Date deployedAt) {
        EnsureUtil.ensureNotNull("deployedAt", (Object)deployedAt);
        this.shouldJoinDeploymentTable = true;
        this.deployedAt = deployedAt;
        return this;
    }

    @Override
    public ProcessDefinitionQuery processDefinitionKey(String key) {
        EnsureUtil.ensureNotNull("key", (Object)key);
        this.key = key;
        return this;
    }

    @Override
    public ProcessDefinitionQueryImpl processDefinitionKeysIn(String ... processDefinitionKeys) {
        return (ProcessDefinitionQueryImpl)this.processDefinitionKeyIn(processDefinitionKeys);
    }

    @Override
    public ProcessDefinitionQuery processDefinitionKeyIn(String ... processDefinitionKeys) {
        EnsureUtil.ensureNotNull("keys", processDefinitionKeys);
        this.keys = processDefinitionKeys;
        return this;
    }

    @Override
    public ProcessDefinitionQuery processDefinitionKeyLike(String keyLike) {
        EnsureUtil.ensureNotNull("keyLike", (Object)keyLike);
        this.keyLike = keyLike;
        return this;
    }

    @Override
    public ProcessDefinitionQuery processDefinitionResourceName(String resourceName) {
        EnsureUtil.ensureNotNull("resourceName", (Object)resourceName);
        this.resourceName = resourceName;
        return this;
    }

    @Override
    public ProcessDefinitionQuery processDefinitionResourceNameLike(String resourceNameLike) {
        EnsureUtil.ensureNotNull("resourceNameLike", (Object)resourceNameLike);
        this.resourceNameLike = resourceNameLike;
        return this;
    }

    @Override
    public ProcessDefinitionQuery processDefinitionVersion(Integer version) {
        EnsureUtil.ensureNotNull("version", (Object)version);
        EnsureUtil.ensurePositive("version", version.longValue());
        this.version = version;
        return this;
    }

    @Override
    public ProcessDefinitionQuery latestVersion() {
        this.latest = true;
        return this;
    }

    @Override
    public ProcessDefinitionQuery active() {
        this.suspensionState = SuspensionState.ACTIVE;
        return this;
    }

    @Override
    public ProcessDefinitionQuery suspended() {
        this.suspensionState = SuspensionState.SUSPENDED;
        return this;
    }

    @Override
    public ProcessDefinitionQuery messageEventSubscription(String messageName) {
        return this.eventSubscription(EventType.MESSAGE, messageName);
    }

    @Override
    public ProcessDefinitionQuery messageEventSubscriptionName(String messageName) {
        return this.eventSubscription(EventType.MESSAGE, messageName);
    }

    public ProcessDefinitionQuery processDefinitionStarter(String procDefId) {
        this.procDefId = procDefId;
        return this;
    }

    public ProcessDefinitionQuery eventSubscription(EventType eventType, String eventName) {
        EnsureUtil.ensureNotNull("event type", (Object)eventType);
        EnsureUtil.ensureNotNull("event name", (Object)eventName);
        this.eventSubscriptionType = eventType.name();
        this.eventSubscriptionName = eventName;
        return this;
    }

    @Override
    public ProcessDefinitionQuery incidentType(String incidentType) {
        EnsureUtil.ensureNotNull("incident type", (Object)incidentType);
        this.incidentType = incidentType;
        return this;
    }

    @Override
    public ProcessDefinitionQuery incidentId(String incidentId) {
        EnsureUtil.ensureNotNull("incident id", (Object)incidentId);
        this.incidentId = incidentId;
        return this;
    }

    @Override
    public ProcessDefinitionQuery incidentMessage(String incidentMessage) {
        EnsureUtil.ensureNotNull("incident message", (Object)incidentMessage);
        this.incidentMessage = incidentMessage;
        return this;
    }

    @Override
    public ProcessDefinitionQuery incidentMessageLike(String incidentMessageLike) {
        EnsureUtil.ensureNotNull("incident messageLike", (Object)incidentMessageLike);
        this.incidentMessageLike = incidentMessageLike;
        return this;
    }

    @Override
    public ProcessDefinitionQuery tenantIdIn(String ... tenantIds) {
        EnsureUtil.ensureNotNull("tenantIds", tenantIds);
        this.tenantIds = tenantIds;
        this.isTenantIdSet = true;
        return this;
    }

    @Override
    public ProcessDefinitionQuery withoutTenantId() {
        this.isTenantIdSet = true;
        this.tenantIds = null;
        return this;
    }

    @Override
    public ProcessDefinitionQuery includeProcessDefinitionsWithoutTenantId() {
        this.includeDefinitionsWithoutTenantId = true;
        return this;
    }

    @Override
    public ProcessDefinitionQuery versionTag(String versionTag) {
        EnsureUtil.ensureNotNull("versionTag", (Object)versionTag);
        this.versionTag = versionTag;
        this.isVersionTagSet = true;
        return this;
    }

    @Override
    public ProcessDefinitionQuery versionTagLike(String versionTagLike) {
        EnsureUtil.ensureNotNull("versionTagLike", (Object)versionTagLike);
        this.versionTagLike = versionTagLike;
        return this;
    }

    @Override
    public ProcessDefinitionQuery withoutVersionTag() {
        this.isVersionTagSet = true;
        this.versionTag = null;
        return this;
    }

    @Override
    public ProcessDefinitionQuery startableInTasklist() {
        this.isStartableInTasklist = true;
        return this;
    }

    @Override
    public ProcessDefinitionQuery notStartableInTasklist() {
        this.isNotStartableInTasklist = true;
        return this;
    }

    @Override
    public ProcessDefinitionQuery startablePermissionCheck() {
        this.startablePermissionCheck = true;
        return this;
    }

    @Override
    public ProcessDefinitionQuery orderByDeploymentId() {
        return (ProcessDefinitionQuery)this.orderBy(ProcessDefinitionQueryProperty.DEPLOYMENT_ID);
    }

    @Override
    public ProcessDefinitionQuery orderByDeploymentTime() {
        this.shouldJoinDeploymentTable = true;
        return (ProcessDefinitionQuery)this.orderBy(new QueryOrderingProperty("deployment", ProcessDefinitionQueryProperty.DEPLOY_TIME));
    }

    @Override
    public ProcessDefinitionQuery orderByProcessDefinitionKey() {
        return (ProcessDefinitionQuery)this.orderBy(ProcessDefinitionQueryProperty.PROCESS_DEFINITION_KEY);
    }

    @Override
    public ProcessDefinitionQuery orderByProcessDefinitionCategory() {
        return (ProcessDefinitionQuery)this.orderBy(ProcessDefinitionQueryProperty.PROCESS_DEFINITION_CATEGORY);
    }

    @Override
    public ProcessDefinitionQuery orderByProcessDefinitionId() {
        return (ProcessDefinitionQuery)this.orderBy(ProcessDefinitionQueryProperty.PROCESS_DEFINITION_ID);
    }

    @Override
    public ProcessDefinitionQuery orderByProcessDefinitionVersion() {
        return (ProcessDefinitionQuery)this.orderBy(ProcessDefinitionQueryProperty.PROCESS_DEFINITION_VERSION);
    }

    @Override
    public ProcessDefinitionQuery orderByProcessDefinitionName() {
        return (ProcessDefinitionQuery)this.orderBy(ProcessDefinitionQueryProperty.PROCESS_DEFINITION_NAME);
    }

    @Override
    public ProcessDefinitionQuery orderByTenantId() {
        return (ProcessDefinitionQuery)this.orderBy(ProcessDefinitionQueryProperty.TENANT_ID);
    }

    @Override
    public ProcessDefinitionQuery orderByVersionTag() {
        return (ProcessDefinitionQuery)this.orderBy(ProcessDefinitionQueryProperty.VERSION_TAG);
    }

    @Override
    public ProcessDefinitionQuery startableByUser(String userId) {
        EnsureUtil.ensureNotNull("userId", (Object)userId);
        this.authorizationUserId = userId;
        return this;
    }

    @Override
    protected boolean hasExcludingConditions() {
        return super.hasExcludingConditions() || CompareUtil.elementIsNotContainedInArray(this.id, this.ids);
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.checkQueryOk();
        this.getCandidateGroups();
        return commandContext.getProcessDefinitionManager().findProcessDefinitionCountByQueryCriteria(this);
    }

    @Override
    public List<ProcessDefinition> executeList(CommandContext commandContext, Page page) {
        this.checkQueryOk();
        this.getCandidateGroups();
        List<ProcessDefinition> list = commandContext.getProcessDefinitionManager().findProcessDefinitionsByQueryCriteria(this, page);
        boolean shouldQueryAddBpmnModelInstancesToCache = commandContext.getProcessEngineConfiguration().getEnableFetchProcessDefinitionDescription();
        if (shouldQueryAddBpmnModelInstancesToCache) {
            this.addProcessDefinitionToCacheAndRetrieveDocumentation(list);
        }
        return list;
    }

    protected void addProcessDefinitionToCacheAndRetrieveDocumentation(List<ProcessDefinition> list) {
        for (ProcessDefinition processDefinition : list) {
            BpmnModelInstance bpmnModelInstance = Context.getProcessEngineConfiguration().getDeploymentCache().findBpmnModelInstanceForProcessDefinition((ProcessDefinitionEntity)processDefinition);
            ModelElementInstance processElement = bpmnModelInstance.getModelElementById(processDefinition.getKey());
            if (processElement == null) continue;
            Collection documentations = processElement.getChildElementsByType(Documentation.class);
            ArrayList<String> docStrings = new ArrayList<String>();
            for (Documentation documentation : documentations) {
                docStrings.add(documentation.getTextContent());
            }
            ProcessDefinitionEntity processDefinitionEntity = (ProcessDefinitionEntity)processDefinition;
            processDefinitionEntity.setProperty("documentation", BpmnParse.parseDocumentation(docStrings));
        }
    }

    @Override
    public void checkQueryOk() {
        super.checkQueryOk();
        if (this.latest && (this.id != null || this.version != null || this.deploymentId != null)) {
            throw new ProcessEngineException("Calling latest() can only be used in combination with key(String) and keyLike(String) or name(String) and nameLike(String)");
        }
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public Date getDeployedAfter() {
        return this.deployedAfter;
    }

    public Date getDeployedAt() {
        return this.deployedAt;
    }

    public String getId() {
        return this.id;
    }

    public String[] getIds() {
        return this.ids;
    }

    public String getName() {
        return this.name;
    }

    public String getNameLike() {
        return this.nameLike;
    }

    public String getKey() {
        return this.key;
    }

    public String getKeyLike() {
        return this.keyLike;
    }

    public Integer getVersion() {
        return this.version;
    }

    public boolean isLatest() {
        return this.latest;
    }

    public String getCategory() {
        return this.category;
    }

    public String getCategoryLike() {
        return this.categoryLike;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public String getResourceNameLike() {
        return this.resourceNameLike;
    }

    public SuspensionState getSuspensionState() {
        return this.suspensionState;
    }

    public void setSuspensionState(SuspensionState suspensionState) {
        this.suspensionState = suspensionState;
    }

    public String getIncidentId() {
        return this.incidentId;
    }

    public String getIncidentType() {
        return this.incidentType;
    }

    public String getIncidentMessage() {
        return this.incidentMessage;
    }

    public String getIncidentMessageLike() {
        return this.incidentMessageLike;
    }

    public String getVersionTag() {
        return this.versionTag;
    }

    public boolean isStartableInTasklist() {
        return this.isStartableInTasklist;
    }

    public boolean isNotStartableInTasklist() {
        return this.isNotStartableInTasklist;
    }

    public boolean isStartablePermissionCheck() {
        return this.startablePermissionCheck;
    }

    public void setProcessDefinitionCreatePermissionChecks(List<PermissionCheck> processDefinitionCreatePermissionChecks) {
        this.processDefinitionCreatePermissionChecks = processDefinitionCreatePermissionChecks;
    }

    public List<PermissionCheck> getProcessDefinitionCreatePermissionChecks() {
        return this.processDefinitionCreatePermissionChecks;
    }

    public boolean isShouldJoinDeploymentTable() {
        return this.shouldJoinDeploymentTable;
    }

    public void addProcessDefinitionCreatePermissionCheck(CompositePermissionCheck processDefinitionCreatePermissionCheck) {
        this.processDefinitionCreatePermissionChecks.addAll(processDefinitionCreatePermissionCheck.getAllPermissionChecks());
    }

    public List<String> getCandidateGroups() {
        if (this.cachedCandidateGroups != null) {
            return this.cachedCandidateGroups;
        }
        if (this.authorizationUserId != null) {
            List groups = Context.getCommandContext().getReadOnlyIdentityProvider().createGroupQuery().groupMember(this.authorizationUserId).list();
            this.cachedCandidateGroups = groups.stream().map(Group::getId).collect(Collectors.toList());
        }
        return this.cachedCandidateGroups;
    }
}

