/*
 * Decompiled with CFR 0.152.
 */
package camundajar.impl.com.cronutils.model.time.generator;

import camundajar.impl.com.cronutils.model.field.CronField;
import camundajar.impl.com.cronutils.model.field.CronFieldName;
import camundajar.impl.com.cronutils.model.field.expression.Always;
import camundajar.impl.com.cronutils.model.field.expression.FieldExpression;
import camundajar.impl.com.cronutils.model.time.generator.FieldValueGenerator;
import camundajar.impl.com.cronutils.model.time.generator.NoSuchValueException;
import java.util.ArrayList;
import java.util.List;

class AlwaysFieldValueGenerator
extends FieldValueGenerator {
    public AlwaysFieldValueGenerator(CronField cronField) {
        super(cronField);
    }

    @Override
    public int generateNextValue(int reference) throws NoSuchValueException {
        int newvalue = reference + 1;
        if (newvalue <= this.cronField.getConstraints().getEndRange()) {
            return newvalue;
        }
        throw new NoSuchValueException();
    }

    @Override
    public int generatePreviousValue(int reference) throws NoSuchValueException {
        int newvalue = reference - 1;
        if (newvalue >= this.cronField.getConstraints().getStartRange()) {
            return newvalue;
        }
        throw new NoSuchValueException();
    }

    @Override
    protected List<Integer> generateCandidatesNotIncludingIntervalExtremes(int start, int end) {
        ArrayList<Integer> values = new ArrayList<Integer>();
        for (int j = start + 1; j < end; ++j) {
            values.add(j);
        }
        return values;
    }

    @Override
    public boolean isMatch(int value) {
        return this.cronField.getField() == CronFieldName.DAY_OF_WEEK || this.cronField.getConstraints().isInRange(value);
    }

    @Override
    protected boolean matchesFieldExpressionClass(FieldExpression fieldExpression) {
        return fieldExpression instanceof Always;
    }
}

