/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl;

import java.util.Date;
import java.util.List;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.history.HistoricDecisionInstance;
import org.camunda.bpm.engine.history.HistoricDecisionInstanceQuery;
import org.camunda.bpm.engine.impl.AbstractQuery;
import org.camunda.bpm.engine.impl.HistoricDecisionInstanceQueryProperty;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.impl.util.ImmutablePair;

public class HistoricDecisionInstanceQueryImpl
extends AbstractQuery<HistoricDecisionInstanceQuery, HistoricDecisionInstance>
implements HistoricDecisionInstanceQuery {
    private static final long serialVersionUID = 1L;
    protected String decisionInstanceId;
    protected String[] decisionInstanceIdIn;
    protected String decisionDefinitionId;
    protected String[] decisionDefinitionIdIn;
    protected String decisionDefinitionKey;
    protected String[] decisionDefinitionKeyIn;
    protected String decisionDefinitionName;
    protected String decisionDefinitionNameLike;
    protected String processDefinitionKey;
    protected String processDefinitionId;
    protected String processInstanceId;
    protected String caseDefinitionKey;
    protected String caseDefinitionId;
    protected String caseInstanceId;
    protected String[] activityInstanceIds;
    protected String[] activityIds;
    protected Date evaluatedBefore;
    protected Date evaluatedAfter;
    protected String userId;
    protected boolean includeInput = false;
    protected boolean includeOutputs = false;
    protected boolean isByteArrayFetchingEnabled = true;
    protected boolean isCustomObjectDeserializationEnabled = true;
    protected String rootDecisionInstanceId;
    protected boolean rootDecisionInstancesOnly = false;
    protected String decisionRequirementsDefinitionId;
    protected String decisionRequirementsDefinitionKey;
    protected String[] tenantIds;
    protected boolean isTenantIdSet;

    public HistoricDecisionInstanceQueryImpl() {
    }

    public HistoricDecisionInstanceQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    @Override
    public HistoricDecisionInstanceQuery decisionInstanceId(String decisionInstanceId) {
        EnsureUtil.ensureNotNull(NotValidException.class, "decisionInstanceId", (Object)decisionInstanceId);
        this.decisionInstanceId = decisionInstanceId;
        return this;
    }

    @Override
    public HistoricDecisionInstanceQuery decisionInstanceIdIn(String ... decisionInstanceIdIn) {
        EnsureUtil.ensureNotNull("decisionInstanceIdIn", decisionInstanceIdIn);
        this.decisionInstanceIdIn = decisionInstanceIdIn;
        return this;
    }

    @Override
    public HistoricDecisionInstanceQuery decisionDefinitionId(String decisionDefinitionId) {
        EnsureUtil.ensureNotNull(NotValidException.class, "decisionDefinitionId", (Object)decisionDefinitionId);
        this.decisionDefinitionId = decisionDefinitionId;
        return this;
    }

    @Override
    public HistoricDecisionInstanceQuery decisionDefinitionIdIn(String ... decisionDefinitionIdIn) {
        EnsureUtil.ensureNotNull(NotValidException.class, "decisionDefinitionIdIn", (Object[])decisionDefinitionIdIn);
        this.decisionDefinitionIdIn = decisionDefinitionIdIn;
        return this;
    }

    @Override
    public HistoricDecisionInstanceQuery decisionDefinitionKey(String decisionDefinitionKey) {
        EnsureUtil.ensureNotNull(NotValidException.class, "decisionDefinitionKey", (Object)decisionDefinitionKey);
        this.decisionDefinitionKey = decisionDefinitionKey;
        return this;
    }

    @Override
    public HistoricDecisionInstanceQuery decisionDefinitionKeyIn(String ... decisionDefinitionKeyIn) {
        EnsureUtil.ensureNotNull(NotValidException.class, "decisionDefinitionKeyIn", (Object[])decisionDefinitionKeyIn);
        this.decisionDefinitionKeyIn = decisionDefinitionKeyIn;
        return this;
    }

    @Override
    public HistoricDecisionInstanceQuery decisionDefinitionName(String decisionDefinitionName) {
        EnsureUtil.ensureNotNull(NotValidException.class, "decisionDefinitionName", (Object)decisionDefinitionName);
        this.decisionDefinitionName = decisionDefinitionName;
        return this;
    }

    @Override
    public HistoricDecisionInstanceQuery decisionDefinitionNameLike(String decisionDefinitionNameLike) {
        EnsureUtil.ensureNotNull(NotValidException.class, "decisionDefinitionNameLike", (Object)decisionDefinitionNameLike);
        this.decisionDefinitionNameLike = decisionDefinitionNameLike;
        return this;
    }

    @Override
    public HistoricDecisionInstanceQuery processDefinitionKey(String processDefinitionKey) {
        EnsureUtil.ensureNotNull(NotValidException.class, "processDefinitionKey", (Object)processDefinitionKey);
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    @Override
    public HistoricDecisionInstanceQuery processDefinitionId(String processDefinitionId) {
        EnsureUtil.ensureNotNull(NotValidException.class, "processDefinitionId", (Object)processDefinitionId);
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Override
    public HistoricDecisionInstanceQuery processInstanceId(String processInstanceId) {
        EnsureUtil.ensureNotNull(NotValidException.class, "processInstanceId", (Object)processInstanceId);
        this.processInstanceId = processInstanceId;
        return this;
    }

    @Override
    public HistoricDecisionInstanceQuery caseDefinitionKey(String caseDefinitionKey) {
        EnsureUtil.ensureNotNull(NotValidException.class, "caseDefinitionKey", (Object)caseDefinitionKey);
        this.caseDefinitionKey = caseDefinitionKey;
        return this;
    }

    @Override
    public HistoricDecisionInstanceQuery caseDefinitionId(String caseDefinitionId) {
        EnsureUtil.ensureNotNull(NotValidException.class, "caseDefinitionId", (Object)caseDefinitionId);
        this.caseDefinitionId = caseDefinitionId;
        return this;
    }

    @Override
    public HistoricDecisionInstanceQuery caseInstanceId(String caseInstanceId) {
        EnsureUtil.ensureNotNull(NotValidException.class, "caseInstanceId", (Object)caseInstanceId);
        this.caseInstanceId = caseInstanceId;
        return this;
    }

    @Override
    public HistoricDecisionInstanceQuery activityIdIn(String ... activityIds) {
        EnsureUtil.ensureNotNull("activityIds", activityIds);
        this.activityIds = activityIds;
        return this;
    }

    @Override
    public HistoricDecisionInstanceQuery activityInstanceIdIn(String ... activityInstanceIds) {
        EnsureUtil.ensureNotNull("activityInstanceIds", activityInstanceIds);
        this.activityInstanceIds = activityInstanceIds;
        return this;
    }

    @Override
    public HistoricDecisionInstanceQuery evaluatedBefore(Date evaluatedBefore) {
        EnsureUtil.ensureNotNull(NotValidException.class, "evaluatedBefore", (Object)evaluatedBefore);
        this.evaluatedBefore = evaluatedBefore;
        return this;
    }

    @Override
    public HistoricDecisionInstanceQuery evaluatedAfter(Date evaluatedAfter) {
        EnsureUtil.ensureNotNull(NotValidException.class, "evaluatedAfter", (Object)evaluatedAfter);
        this.evaluatedAfter = evaluatedAfter;
        return this;
    }

    @Override
    public HistoricDecisionInstanceQuery tenantIdIn(String ... tenantIds) {
        EnsureUtil.ensureNotNull("tenantIds", tenantIds);
        this.tenantIds = tenantIds;
        this.isTenantIdSet = true;
        return this;
    }

    @Override
    public HistoricDecisionInstanceQuery withoutTenantId() {
        this.tenantIds = null;
        this.isTenantIdSet = true;
        return this;
    }

    @Override
    public HistoricDecisionInstanceQuery orderByTenantId() {
        return (HistoricDecisionInstanceQuery)this.orderBy(HistoricDecisionInstanceQueryProperty.TENANT_ID);
    }

    @Override
    public HistoricDecisionInstanceQuery userId(String userId) {
        EnsureUtil.ensureNotNull(NotValidException.class, "userId", (Object)userId);
        this.userId = userId;
        return this;
    }

    @Override
    public HistoricDecisionInstanceQuery orderByEvaluationTime() {
        this.orderBy(HistoricDecisionInstanceQueryProperty.EVALUATION_TIME);
        return this;
    }

    @Override
    public HistoricDecisionInstanceQuery orderByDecisionInstanceId() {
        this.orderBy(HistoricDecisionInstanceQueryProperty.DECISION_INSTANCE_ID);
        return this;
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.checkQueryOk();
        return commandContext.getHistoricDecisionInstanceManager().findHistoricDecisionInstanceCountByQueryCriteria(this);
    }

    @Override
    public List<HistoricDecisionInstance> executeList(CommandContext commandContext, Page page) {
        this.checkQueryOk();
        return commandContext.getHistoricDecisionInstanceManager().findHistoricDecisionInstancesByQueryCriteria(this, page);
    }

    @Override
    public List<ImmutablePair<String, String>> executeDeploymentIdMappingsList(CommandContext commandContext) {
        this.checkQueryOk();
        return commandContext.getHistoricDecisionInstanceManager().findHistoricDecisionInstanceDeploymentIdMappingsByQueryCriteria(this);
    }

    public String getDecisionDefinitionId() {
        return this.decisionDefinitionId;
    }

    public String getDecisionDefinitionKey() {
        return this.decisionDefinitionKey;
    }

    public String getDecisionDefinitionName() {
        return this.decisionDefinitionName;
    }

    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public String getCaseDefinitionKey() {
        return this.caseDefinitionKey;
    }

    public String getCaseDefinitionId() {
        return this.caseDefinitionId;
    }

    public String getCaseInstanceId() {
        return this.caseInstanceId;
    }

    public String[] getActivityInstanceIds() {
        return this.activityInstanceIds;
    }

    public String[] getActivityIds() {
        return this.activityIds;
    }

    public String[] getTenantIds() {
        return this.tenantIds;
    }

    @Override
    public HistoricDecisionInstanceQuery includeInputs() {
        this.includeInput = true;
        return this;
    }

    @Override
    public HistoricDecisionInstanceQuery includeOutputs() {
        this.includeOutputs = true;
        return this;
    }

    public boolean isIncludeInput() {
        return this.includeInput;
    }

    public boolean isIncludeOutputs() {
        return this.includeOutputs;
    }

    @Override
    public HistoricDecisionInstanceQuery disableBinaryFetching() {
        this.isByteArrayFetchingEnabled = false;
        return this;
    }

    @Override
    public HistoricDecisionInstanceQuery disableCustomObjectDeserialization() {
        this.isCustomObjectDeserializationEnabled = false;
        return this;
    }

    public boolean isByteArrayFetchingEnabled() {
        return this.isByteArrayFetchingEnabled;
    }

    public boolean isCustomObjectDeserializationEnabled() {
        return this.isCustomObjectDeserializationEnabled;
    }

    public String getRootDecisionInstanceId() {
        return this.rootDecisionInstanceId;
    }

    @Override
    public HistoricDecisionInstanceQuery rootDecisionInstanceId(String rootDecisionInstanceId) {
        EnsureUtil.ensureNotNull(NotValidException.class, "rootDecisionInstanceId", (Object)rootDecisionInstanceId);
        this.rootDecisionInstanceId = rootDecisionInstanceId;
        return this;
    }

    public boolean isRootDecisionInstancesOnly() {
        return this.rootDecisionInstancesOnly;
    }

    @Override
    public HistoricDecisionInstanceQuery rootDecisionInstancesOnly() {
        this.rootDecisionInstancesOnly = true;
        return this;
    }

    @Override
    public HistoricDecisionInstanceQuery decisionRequirementsDefinitionId(String decisionRequirementsDefinitionId) {
        EnsureUtil.ensureNotNull(NotValidException.class, "decisionRequirementsDefinitionId", (Object)decisionRequirementsDefinitionId);
        this.decisionRequirementsDefinitionId = decisionRequirementsDefinitionId;
        return this;
    }

    @Override
    public HistoricDecisionInstanceQuery decisionRequirementsDefinitionKey(String decisionRequirementsDefinitionKey) {
        EnsureUtil.ensureNotNull(NotValidException.class, "decisionRequirementsDefinitionKey", (Object)decisionRequirementsDefinitionKey);
        this.decisionRequirementsDefinitionKey = decisionRequirementsDefinitionKey;
        return this;
    }

    public String getDecisionRequirementsDefinitionId() {
        return this.decisionRequirementsDefinitionId;
    }

    public String getDecisionRequirementsDefinitionKey() {
        return this.decisionRequirementsDefinitionKey;
    }

    public boolean isTenantIdSet() {
        return this.isTenantIdSet;
    }
}

