/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.core.operation;

import java.util.List;
import org.camunda.bpm.engine.delegate.BaseDelegateExecution;
import org.camunda.bpm.engine.delegate.DelegateListener;
import org.camunda.bpm.engine.impl.core.instance.CoreExecution;
import org.camunda.bpm.engine.impl.core.model.CoreModelElement;
import org.camunda.bpm.engine.impl.core.operation.CoreAtomicOperation;
import org.camunda.bpm.engine.impl.pvm.PvmException;

public abstract class AbstractEventAtomicOperation<T extends CoreExecution>
implements CoreAtomicOperation<T> {
    @Override
    public boolean isAsync(T execution) {
        return false;
    }

    @Override
    public void execute(T execution) {
        CoreModelElement scope = this.getScope(execution);
        List<DelegateListener<BaseDelegateExecution>> listeners = this.getListeners(scope, execution);
        int listenerIndex = ((CoreExecution)execution).getListenerIndex();
        if (listenerIndex == 0) {
            execution = this.eventNotificationsStarted(execution);
        }
        if (!this.isSkipNotifyListeners(execution)) {
            if (listeners.size() > listenerIndex) {
                ((CoreExecution)execution).setEventName(this.getEventName());
                ((CoreExecution)execution).setEventSource(scope);
                DelegateListener<BaseDelegateExecution> listener = listeners.get(listenerIndex);
                try {
                    ((CoreExecution)execution).invokeListener(listener);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new PvmException("couldn't execute event listener : " + e.getMessage(), e);
                }
                ((CoreExecution)execution).setListenerIndex(listenerIndex + 1);
                ((CoreExecution)execution).performOperationSync(this);
            } else {
                ((CoreExecution)execution).setListenerIndex(0);
                ((CoreExecution)execution).setEventName(null);
                ((CoreExecution)execution).setEventSource(null);
                this.eventNotificationsCompleted(execution);
            }
        } else {
            this.eventNotificationsCompleted(execution);
        }
    }

    protected List<DelegateListener<? extends BaseDelegateExecution>> getListeners(CoreModelElement scope, T execution) {
        if (((CoreExecution)execution).isSkipCustomListeners()) {
            return scope.getBuiltInListeners(this.getEventName());
        }
        return scope.getListeners(this.getEventName());
    }

    protected boolean isSkipNotifyListeners(T execution) {
        return false;
    }

    protected T eventNotificationsStarted(T execution) {
        return execution;
    }

    protected abstract CoreModelElement getScope(T var1);

    protected abstract String getEventName();

    protected abstract void eventNotificationsCompleted(T var1);
}

