/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.dmn.result;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.camunda.bpm.dmn.engine.DmnDecisionTableResult;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.dmn.DecisionLogger;
import org.camunda.bpm.engine.impl.dmn.result.DecisionTableResultMapper;

public class CollectEntriesDecisionTableResultMapper
implements DecisionTableResultMapper {
    protected static final DecisionLogger LOG = ProcessEngineLogger.DECISION_LOGGER;

    @Override
    public Object mapDecisionTableResult(DmnDecisionTableResult decisionResult) {
        if (decisionResult.isEmpty()) {
            return Collections.emptyList();
        }
        Set<String> outputNames = this.collectOutputNames(decisionResult);
        if (outputNames.size() > 1) {
            throw LOG.decisionResultCollectMappingException(outputNames, decisionResult, this);
        }
        String outputName = outputNames.iterator().next();
        return decisionResult.collectEntries(outputName);
    }

    protected Set<String> collectOutputNames(DmnDecisionTableResult decisionResult) {
        HashSet<String> outputNames = new HashSet<String>();
        for (Map entryMap : decisionResult.getResultList()) {
            outputNames.addAll(entryMap.keySet());
        }
        return outputNames;
    }

    public String toString() {
        return "CollectEntriesDecisionTableResultMapper{}";
    }
}

