/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.json;

import java.util.ArrayList;
import java.util.List;
import org.camunda.bpm.engine.impl.json.JsonObjectConverter;
import org.camunda.bpm.engine.impl.json.MigrationPlanJsonConverter;
import org.camunda.bpm.engine.impl.migration.batch.MigrationBatchConfiguration;
import org.camunda.bpm.engine.impl.util.JsonUtil;
import org.camunda.bpm.engine.impl.util.json.JSONObject;

public class MigrationBatchConfigurationJsonConverter
extends JsonObjectConverter<MigrationBatchConfiguration> {
    public static final MigrationBatchConfigurationJsonConverter INSTANCE = new MigrationBatchConfigurationJsonConverter();
    public static final String MIGRATION_PLAN = "migrationPlan";
    public static final String PROCESS_INSTANCE_IDS = "processInstanceIds";
    public static final String SKIP_LISTENERS = "skipListeners";
    public static final String SKIP_IO_MAPPINGS = "skipIoMappings";

    @Override
    public JSONObject toJsonObject(MigrationBatchConfiguration configuration) {
        JSONObject json = new JSONObject();
        JsonUtil.addField(json, MIGRATION_PLAN, MigrationPlanJsonConverter.INSTANCE, configuration.getMigrationPlan());
        JsonUtil.addListField(json, PROCESS_INSTANCE_IDS, configuration.getProcessInstanceIds());
        JsonUtil.addField(json, SKIP_LISTENERS, configuration.isSkipCustomListeners());
        JsonUtil.addField(json, SKIP_IO_MAPPINGS, configuration.isSkipIoMappings());
        return json;
    }

    @Override
    public MigrationBatchConfiguration toObject(JSONObject json) {
        MigrationBatchConfiguration configuration = new MigrationBatchConfiguration();
        configuration.setMigrationPlan(JsonUtil.jsonObject(json.getJSONObject(MIGRATION_PLAN), MigrationPlanJsonConverter.INSTANCE));
        configuration.setProcessInstanceIds(this.readProcessInstanceIds(json));
        configuration.setSkipCustomListeners(json.getBoolean(SKIP_LISTENERS));
        configuration.setSkipIoMappings(json.getBoolean(SKIP_IO_MAPPINGS));
        return configuration;
    }

    protected List<String> readProcessInstanceIds(JSONObject jsonObject) {
        List<Object> objects = JsonUtil.jsonArrayAsList(jsonObject.getJSONArray(PROCESS_INSTANCE_IDS));
        ArrayList<String> processInstanceIds = new ArrayList<String>();
        for (Object object : objects) {
            processInstanceIds.add((String)object);
        }
        return processInstanceIds;
    }
}

