/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.migration.instance.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.camunda.bpm.engine.impl.migration.instance.MigratingActivityInstance;
import org.camunda.bpm.engine.impl.persistence.entity.CompensateEventSubscriptionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.tree.ReferenceWalker;

public class CompensationEventSubscriptionWalker
extends ReferenceWalker<CompensateEventSubscriptionEntity> {
    public CompensationEventSubscriptionWalker(Collection<MigratingActivityInstance> collection) {
        super(CompensationEventSubscriptionWalker.collectCompensationEventSubscriptions(collection));
    }

    protected static List<CompensateEventSubscriptionEntity> collectCompensationEventSubscriptions(Collection<MigratingActivityInstance> activityInstances) {
        ArrayList<CompensateEventSubscriptionEntity> eventSubscriptions = new ArrayList<CompensateEventSubscriptionEntity>();
        for (MigratingActivityInstance activityInstance : activityInstances) {
            if (!activityInstance.getSourceScope().isScope()) continue;
            ExecutionEntity scopeExecution = activityInstance.resolveRepresentativeExecution();
            eventSubscriptions.addAll(scopeExecution.getCompensateEventSubscriptions());
        }
        return eventSubscriptions;
    }

    @Override
    protected Collection<CompensateEventSubscriptionEntity> nextElements() {
        CompensateEventSubscriptionEntity eventSubscriptionEntity = (CompensateEventSubscriptionEntity)this.getCurrentElement();
        ExecutionEntity compensatingExecution = eventSubscriptionEntity.getCompensatingExecution();
        if (compensatingExecution != null) {
            return compensatingExecution.getCompensateEventSubscriptions();
        }
        return Collections.emptyList();
    }
}

