/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl;

import java.util.ArrayList;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.AbstractQuery;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.db.PermissionCheck;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.management.ActivityStatistics;
import org.camunda.bpm.engine.management.ActivityStatisticsQuery;

public class ActivityStatisticsQueryImpl
extends AbstractQuery<ActivityStatisticsQuery, ActivityStatistics>
implements ActivityStatisticsQuery {
    protected static final long serialVersionUID = 1L;
    protected boolean includeFailedJobs = false;
    protected String processDefinitionId;
    protected boolean includeIncidents;
    protected String includeIncidentsForType;
    protected List<PermissionCheck> processInstancePermissionChecks = new ArrayList<PermissionCheck>();
    protected List<PermissionCheck> jobPermissionChecks = new ArrayList<PermissionCheck>();
    protected List<PermissionCheck> incidentPermissionChecks = new ArrayList<PermissionCheck>();

    public ActivityStatisticsQueryImpl(String processDefinitionId, CommandExecutor executor) {
        super(executor);
        this.processDefinitionId = processDefinitionId;
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.checkQueryOk();
        return commandContext.getStatisticsManager().getStatisticsCountGroupedByActivity(this);
    }

    @Override
    public List<ActivityStatistics> executeList(CommandContext commandContext, Page page) {
        this.checkQueryOk();
        return commandContext.getStatisticsManager().getStatisticsGroupedByActivity(this, page);
    }

    @Override
    public ActivityStatisticsQuery includeFailedJobs() {
        this.includeFailedJobs = true;
        return this;
    }

    @Override
    public ActivityStatisticsQuery includeIncidents() {
        this.includeIncidents = true;
        return this;
    }

    @Override
    public ActivityStatisticsQuery includeIncidentsForType(String incidentType) {
        this.includeIncidentsForType = incidentType;
        return this;
    }

    public boolean isFailedJobsToInclude() {
        return this.includeFailedJobs;
    }

    public boolean isIncidentsToInclude() {
        return this.includeIncidents || this.includeIncidentsForType != null;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    @Override
    protected void checkQueryOk() {
        super.checkQueryOk();
        EnsureUtil.ensureNotNull("No valid process definition id supplied", "processDefinitionId", (Object)this.processDefinitionId);
        if (this.includeIncidents && this.includeIncidentsForType != null) {
            throw new ProcessEngineException("Invalid query: It is not possible to use includeIncident() and includeIncidentForType() to execute one query.");
        }
    }

    public List<PermissionCheck> getProcessInstancePermissionChecks() {
        return this.processInstancePermissionChecks;
    }

    public void setProcessInstancePermissionChecks(List<PermissionCheck> processInstancePermissionChecks) {
        this.processInstancePermissionChecks = processInstancePermissionChecks;
    }

    public void addProcessInstancePermissionCheck(PermissionCheck permissionCheck) {
        this.processInstancePermissionChecks.add(permissionCheck);
    }

    public List<PermissionCheck> getJobPermissionChecks() {
        return this.jobPermissionChecks;
    }

    public void setJobPermissionChecks(List<PermissionCheck> jobPermissionChecks) {
        this.jobPermissionChecks = jobPermissionChecks;
    }

    public void addJobPermissionCheck(PermissionCheck permissionCheck) {
        this.jobPermissionChecks.add(permissionCheck);
    }

    public List<PermissionCheck> getIncidentPermissionChecks() {
        return this.incidentPermissionChecks;
    }

    public void setIncidentPermissionChecks(List<PermissionCheck> incidentPermissionChecks) {
        this.incidentPermissionChecks = incidentPermissionChecks;
    }

    public void addIncidentPermissionCheck(PermissionCheck permissionCheck) {
        this.incidentPermissionChecks.add(permissionCheck);
    }
}

