/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmmn.cmd;

import java.io.InputStream;
import java.io.Serializable;
import java.util.concurrent.Callable;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.cfg.CommandChecker;
import org.camunda.bpm.engine.impl.cmd.GetDeploymentResourceCmd;
import org.camunda.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionEntity;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;

public class GetDeploymentCaseDiagramCmd
implements Command<InputStream>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String caseDefinitionId;

    public GetDeploymentCaseDiagramCmd(String caseDefinitionId) {
        if (caseDefinitionId == null || caseDefinitionId.length() < 1) {
            throw new ProcessEngineException("The case definition id is mandatory, but '" + caseDefinitionId + "' has been provided.");
        }
        this.caseDefinitionId = caseDefinitionId;
    }

    @Override
    public InputStream execute(final CommandContext commandContext) {
        CaseDefinitionEntity caseDefinition = Context.getProcessEngineConfiguration().getDeploymentCache().findDeployedCaseDefinitionById(this.caseDefinitionId);
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkReadCaseDefinition(caseDefinition);
        }
        final String deploymentId = caseDefinition.getDeploymentId();
        final String resourceName = caseDefinition.getDiagramResourceName();
        InputStream caseDiagramStream = null;
        if (resourceName != null) {
            caseDiagramStream = commandContext.runWithoutAuthorization(new Callable<InputStream>(){

                @Override
                public InputStream call() throws Exception {
                    return new GetDeploymentResourceCmd(deploymentId, resourceName).execute(commandContext);
                }
            });
        }
        return caseDiagramStream;
    }
}

