/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.jobexecutor;

import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.jobexecutor.JobHandler;
import org.camunda.bpm.engine.impl.jobexecutor.JobHandlerConfiguration;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;

public abstract class TimerEventJobHandler
implements JobHandler<TimerJobConfiguration> {
    public static final String JOB_HANDLER_CONFIG_PROPERTY_DELIMITER = "$";
    public static final String JOB_HANDLER_CONFIG_PROPERTY_FOLLOW_UP_JOB_CREATED = "followUpJobCreated";

    @Override
    public TimerJobConfiguration newConfiguration(String canonicalString) {
        String[] configParts = canonicalString.split("\\$");
        if (configParts.length > 2) {
            throw new ProcessEngineException("Illegal timer job handler configuration: '" + canonicalString + "': exprecting a one or two part configuration seperated by '" + JOB_HANDLER_CONFIG_PROPERTY_DELIMITER + "'.");
        }
        TimerJobConfiguration configuration = new TimerJobConfiguration();
        configuration.timerElementKey = configParts[0];
        if (configParts.length == 2) {
            configuration.followUpJobCreated = JOB_HANDLER_CONFIG_PROPERTY_FOLLOW_UP_JOB_CREATED.equals(configParts[1]);
        }
        return configuration;
    }

    @Override
    public void onDelete(TimerJobConfiguration configuration, JobEntity jobEntity) {
    }

    public static class TimerJobConfiguration
    implements JobHandlerConfiguration {
        protected String timerElementKey;
        protected boolean followUpJobCreated;

        public String getTimerElementKey() {
            return this.timerElementKey;
        }

        public void setTimerElementKey(String timerElementKey) {
            this.timerElementKey = timerElementKey;
        }

        public boolean isFollowUpJobCreated() {
            return this.followUpJobCreated;
        }

        public void setFollowUpJobCreated(boolean followUpJobCreated) {
            this.followUpJobCreated = followUpJobCreated;
        }

        @Override
        public String toCanonicalString() {
            String canonicalString = this.timerElementKey;
            if (this.followUpJobCreated) {
                canonicalString = canonicalString + "$followUpJobCreated";
            }
            return canonicalString;
        }
    }
}

