/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.json;

import org.camunda.bpm.engine.impl.json.JsonObjectConverter;
import org.camunda.bpm.engine.impl.json.MigrationInstructionJsonConverter;
import org.camunda.bpm.engine.impl.migration.MigrationPlanImpl;
import org.camunda.bpm.engine.impl.util.JsonUtil;
import org.camunda.bpm.engine.impl.util.json.JSONObject;
import org.camunda.bpm.engine.migration.MigrationPlan;

public class MigrationPlanJsonConverter
extends JsonObjectConverter<MigrationPlan> {
    public static final MigrationPlanJsonConverter INSTANCE = new MigrationPlanJsonConverter();
    public static final String SOURCE_PROCESS_DEFINITION_ID = "sourceProcessDefinitionId";
    public static final String TARGET_PROCESS_DEFINITION_ID = "targetProcessDefinitionId";
    public static final String INSTRUCTIONS = "instructions";

    @Override
    public JSONObject toJsonObject(MigrationPlan migrationPlan) {
        JSONObject json = new JSONObject();
        JsonUtil.addField(json, SOURCE_PROCESS_DEFINITION_ID, migrationPlan.getSourceProcessDefinitionId());
        JsonUtil.addField(json, TARGET_PROCESS_DEFINITION_ID, migrationPlan.getTargetProcessDefinitionId());
        JsonUtil.addListField(json, INSTRUCTIONS, MigrationInstructionJsonConverter.INSTANCE, migrationPlan.getInstructions());
        return json;
    }

    @Override
    public MigrationPlan toObject(JSONObject json) {
        MigrationPlanImpl migrationPlan = new MigrationPlanImpl(json.getString(SOURCE_PROCESS_DEFINITION_ID), json.getString(TARGET_PROCESS_DEFINITION_ID));
        migrationPlan.setInstructions(JsonUtil.jsonArrayAsList(json.getJSONArray(INSTRUCTIONS), MigrationInstructionJsonConverter.INSTANCE));
        return migrationPlan;
    }
}

