/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.migration.instance.parser;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.camunda.bpm.engine.impl.bpmn.parser.EventSubscriptionDeclaration;
import org.camunda.bpm.engine.impl.event.EventType;
import org.camunda.bpm.engine.impl.migration.instance.MigratingActivityInstance;
import org.camunda.bpm.engine.impl.migration.instance.MigratingEventSubscriptionInstance;
import org.camunda.bpm.engine.impl.migration.instance.parser.MigratingDependentInstanceParseHandler;
import org.camunda.bpm.engine.impl.migration.instance.parser.MigratingInstanceParseContext;
import org.camunda.bpm.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.migration.MigrationInstruction;

public class EventSubscriptionInstanceHandler
implements MigratingDependentInstanceParseHandler<MigratingActivityInstance, List<EventSubscriptionEntity>> {
    public static final Set<String> SUPPORTED_EVENT_TYPES = new HashSet<String>(Arrays.asList(EventType.MESSAGE.name(), EventType.SIGNAL.name(), EventType.CONDITONAL.name()));

    @Override
    public void handle(MigratingInstanceParseContext parseContext, MigratingActivityInstance owningInstance, List<EventSubscriptionEntity> elements) {
        Map<String, EventSubscriptionDeclaration> targetDeclarations = this.getDeclarationsByTriggeringActivity(owningInstance.getTargetScope());
        for (EventSubscriptionEntity eventSubscription : elements) {
            if (!this.getSupportedEventTypes().contains(eventSubscription.getEventType())) continue;
            MigrationInstruction migrationInstruction = parseContext.findSingleMigrationInstruction(eventSubscription.getActivityId());
            ActivityImpl targetActivity = parseContext.getTargetActivity(migrationInstruction);
            if (targetActivity != null && owningInstance.migratesTo(targetActivity.getEventScope())) {
                EventSubscriptionDeclaration targetDeclaration = targetDeclarations.remove(targetActivity.getId());
                owningInstance.addMigratingDependentInstance(new MigratingEventSubscriptionInstance(eventSubscription, targetActivity, migrationInstruction.isUpdateEventTrigger(), targetDeclaration));
            } else {
                owningInstance.addRemovingDependentInstance(new MigratingEventSubscriptionInstance(eventSubscription));
            }
            parseContext.consume(eventSubscription);
        }
        if (owningInstance.migrates()) {
            this.addEmergingEventSubscriptions(owningInstance, targetDeclarations.values());
        }
    }

    protected Set<String> getSupportedEventTypes() {
        return SUPPORTED_EVENT_TYPES;
    }

    protected Map<String, EventSubscriptionDeclaration> getDeclarationsByTriggeringActivity(ScopeImpl eventScope) {
        Map<String, EventSubscriptionDeclaration> declarations = EventSubscriptionDeclaration.getDeclarationsForScope(eventScope);
        return new HashMap<String, EventSubscriptionDeclaration>(declarations);
    }

    protected void addEmergingEventSubscriptions(MigratingActivityInstance owningInstance, Collection<EventSubscriptionDeclaration> emergingDeclarations) {
        for (EventSubscriptionDeclaration eventSubscriptionDeclaration : emergingDeclarations) {
            owningInstance.addEmergingDependentInstance(new MigratingEventSubscriptionInstance(eventSubscriptionDeclaration));
        }
    }
}

